"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.Legend = void 0;
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
var _common = require("@kbn/kibana-react-plugin/common");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const StyledFlexItem = (0, _common.euiStyled)(_eui.EuiFlexItem)`
  margin-right: ${props => props.theme.eui.euiSizeM};
  max-width: 7%;
  min-width: 160px;
`;
const Legend = ({
  items,
  render
}) => {
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    gutterSize: "s",
    wrap: true
  }, items.map((item, index) => /*#__PURE__*/_react.default.createElement(StyledFlexItem, {
    key: index
  }, render(item, index))));
};
exports.Legend = Legend;