"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.TagLabel = void 0;
var _react = _interopRequireDefault(require("react"));
var _styledComponents = _interopRequireDefault(require("styled-components"));
var _eui = require("@elastic/eui");
var _constants = require("../../../../../../common/constants");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const BadgeItem = _styledComponents.default.div`
  white-space: nowrap;
  display: inline-block;
  @media (max-width: 1042px) {
    display: inline-block;
    margin-right: 16px;
  }
`;
const TagLabel = ({
  color,
  label,
  status
}) => {
  return /*#__PURE__*/_react.default.createElement(BadgeItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiBadge, {
    color: status === _constants.STATUS.DOWN ? 'danger' : 'success'
  }, label));
};
exports.TagLabel = TagLabel;