"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.StepImageCaption = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _common = require("@kbn/kibana-react-plugin/common");
var _translations = require("./translations");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const StepImageCaption = ({
  captionContent,
  imgRef,
  imgSrc,
  maxSteps,
  setStepNumber,
  stepNumber,
  isLoading,
  label,
  onVisible
}) => {
  const {
    euiTheme
  } = (0, _eui.useEuiTheme)();
  const isSmall = (0, _eui.useIsWithinMaxBreakpoint)('m');
  (0, _react.useEffect)(() => {
    onVisible(true);
    return () => {
      onVisible(false);
    };
    // eslint-disable-next-line react-hooks/exhaustive-deps
  }, []);
  return /*#__PURE__*/_react.default.createElement(CaptionWrapper, {
    onClick: evt => {
      // we don't want this to be captured by row click which leads to step list page
      evt.stopPropagation();
    }
  }, /*#__PURE__*/_react.default.createElement("div", {
    className: "stepArrowsFullScreen"
  }, (imgSrc || imgRef) && /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    alignItems: "center",
    justifyContent: "center"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: true
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
    "data-test-subj": "syntheticsStepImageCaptionButton",
    css: {
      marginLeft: isSmall ? 0 : 'auto'
    },
    disabled: stepNumber === 1,
    onClick: evt => {
      setStepNumber(stepNumber - 1);
      evt.preventDefault();
    },
    iconType: "arrowLeft",
    "aria-label": _translations.prevAriaLabel,
    isLoading: isLoading
  }, _translations.prevAriaLabel)), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(SecondaryText, null, captionContent)), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: true
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
    "data-test-subj": "syntheticsStepImageCaptionButton",
    css: {
      marginRight: isSmall ? 0 : 'auto'
    },
    disabled: stepNumber === maxSteps,
    onClick: evt => {
      setStepNumber(stepNumber + 1);
      evt.stopPropagation();
    },
    iconType: "arrowRight",
    iconSide: "right",
    "aria-label": _translations.nextAriaLabel,
    isLoading: isLoading
  }, _translations.nextAriaLabel))), /*#__PURE__*/_react.default.createElement(SecondaryText, {
    css: {
      padding: euiTheme.size.xs
    },
    className: "eui-textNoWrap",
    size: "s"
  }, label)));
};
exports.StepImageCaption = StepImageCaption;
const CaptionWrapper = _common.euiStyled.div`
  background-color: ${props => props.theme.eui.euiColorLightestShade};
  display: inline-block;
  width: 100%;
  text-decoration: none;
`;
const SecondaryText = (0, _common.euiStyled)(_eui.EuiText)(props => ({
  color: props.theme.eui.euiTextColor
}));