"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.MonitorPageLink = void 0;
var _react = _interopRequireDefault(require("react"));
var _react_router_helpers = require("./react_router_helpers");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const MonitorPageLink = ({
  children,
  monitorId,
  linkParameters
}) => {
  const getLocationTo = () => {
    // encode monitorId param as 64 base string to make it a valid URL, since it can be a url
    return linkParameters ? `/monitor/${btoa(monitorId)}/${linkParameters}` : `/monitor/${btoa(monitorId)}`;
  };
  return /*#__PURE__*/_react.default.createElement(_react_router_helpers.ReactRouterEuiLink, {
    "data-test-subj": `monitor-page-link-${monitorId}`,
    to: getLocationTo()
  }, children);
};
exports.MonitorPageLink = MonitorPageLink;