"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ChartWrapper = void 0;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const ChartWrapper = ({
  loading = false,
  height = '100%',
  children,
  ...rest
}) => {
  const opacity = loading === true ? 0.3 : 1;
  return /*#__PURE__*/_react.default.createElement(_eui.EuiErrorBoundary, null, /*#__PURE__*/_react.default.createElement("div", (0, _extends2.default)({
    style: {
      height,
      opacity,
      transition: 'opacity 0.2s'
    }
  }, rest), children), loading === true && /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    justifyContent: "spaceAround",
    alignItems: "center",
    style: {
      height,
      marginTop: `-${height}`,
      marginBottom: 0
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiLoadingChart, {
    size: "xl"
  }))));
};
exports.ChartWrapper = ChartWrapper;