"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.registerMLEnabledRoute = registerMLEnabledRoute;
var _constants = require("../../common/constants");
var _es_version_precheck = require("../lib/es_version_precheck");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function registerMLEnabledRoute({
  router,
  lib: {
    handleEsError
  }
}) {
  router.get({
    path: `${_constants.API_BASE_PATH}/ml_enabled`,
    security: {
      authz: {
        enabled: false,
        reason: 'Relies on es client for authorization'
      }
    },
    validate: false
  }, (0, _es_version_precheck.versionCheckHandlerWrapper)(async ({
    core
  }, request, response) => {
    try {
      var _settingsResponse$def, _settingsResponse$def2, _settingsResponse$def3;
      const {
        elasticsearch: {
          client
        }
      } = await core;
      const settingsResponse = await client.asCurrentUser.cluster.getSettings({
        include_defaults: true
      });
      const mlEnabled = (_settingsResponse$def = settingsResponse.defaults) === null || _settingsResponse$def === void 0 ? void 0 : (_settingsResponse$def2 = _settingsResponse$def.xpack) === null || _settingsResponse$def2 === void 0 ? void 0 : (_settingsResponse$def3 = _settingsResponse$def2.ml) === null || _settingsResponse$def3 === void 0 ? void 0 : _settingsResponse$def3.enabled;
      return response.ok({
        body: {
          mlEnabled: mlEnabled === 'true'
        }
      });
    } catch (error) {
      return handleEsError({
        error,
        response
      });
    }
  }));
}