"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getMigrateSystemIndicesStep = void 0;
var _react = _interopRequireWildcard(require("react"));
var _i18n = require("@kbn/i18n");
var _i18nReact = require("@kbn/i18n-react");
var _eui = require("@elastic/eui");
var _use_migrate_system_indices = require("./use_migrate_system_indices");
var _migrate_button = require("./migrate_button");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const getFailureCauses = features => {
  const errorsByFeature = {};
  features.forEach(feature => {
    if (feature.migration_status === 'ERROR') {
      feature.indices.forEach(index => {
        if (index.failure_cause) {
          if (!errorsByFeature[feature.feature_name]) {
            errorsByFeature[feature.feature_name] = {
              errors: new Set(),
              indices: 0
            };
          }
          errorsByFeature[feature.feature_name].errors.add(index.failure_cause.error.type);
          errorsByFeature[feature.feature_name].indices += 1;
        }
      });
    }
  });
  return /*#__PURE__*/_react.default.createElement("ul", null, Object.entries(errorsByFeature).map(([feature, {
    errors,
    indices
  }]) => {
    const indicesAffectedText = _i18n.i18n.translate('xpack.upgradeAssistant.systemIndices.migrationFailed.indicesAffected', {
      defaultMessage: '{count, plural, =1 {# index affected} other {# indices affected}}',
      values: {
        count: indices
      }
    });
    return /*#__PURE__*/_react.default.createElement("li", {
      key: feature
    }, /*#__PURE__*/_react.default.createElement("strong", null, feature), ":", ' ', Array.from(errors).map((error, index) => /*#__PURE__*/_react.default.createElement(_react.default.Fragment, {
      key: error
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiCode, null, error), index < errors.size - 1 && ', ')), ' ', "(", indicesAffectedText, ")");
  }));
};
const i18nTexts = {
  title: _i18n.i18n.translate('xpack.upgradeAssistant.overview.systemIndices.title', {
    defaultMessage: 'Migrate system indices'
  }),
  bodyDescription: docLink => {
    return /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.upgradeAssistant.overview.systemIndices.body",
      defaultMessage: "Prepare the system indices that store internal information for the upgrade. This is only required during major version upgrades. Any {hiddenIndicesLink} that need to be reindexed are shown in the next step.",
      values: {
        hiddenIndicesLink: /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
          external: true,
          target: "_blank",
          href: docLink
        }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
          id: "xpack.upgradeAssistant.overview.systemIndices.body.hiddenIndicesLink",
          defaultMessage: "hidden indices"
        }))
      }
    });
  },
  noMigrationNeeded: _i18n.i18n.translate('xpack.upgradeAssistant.overview.systemIndices.noMigrationNeeded', {
    defaultMessage: 'System indices migration not needed.'
  }),
  viewSystemIndicesStatus: _i18n.i18n.translate('xpack.upgradeAssistant.overview.systemIndices.viewSystemIndicesStatus', {
    defaultMessage: 'View migration details'
  }),
  retryButtonLabel: _i18n.i18n.translate('xpack.upgradeAssistant.overview.systemIndices.retryButtonLabel', {
    defaultMessage: 'Retry migration'
  }),
  loadingError: _i18n.i18n.translate('xpack.upgradeAssistant.overview.systemIndices.loadingError', {
    defaultMessage: 'Could not retrieve the system indices status'
  }),
  migrationFailedTitle: _i18n.i18n.translate('xpack.upgradeAssistant.overview.systemIndices.migrationFailedTitle', {
    defaultMessage: 'System indices migration failed'
  }),
  migrationFailedBody: features => {
    const failureCauses = getFailureCauses(features);
    return /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
      size: "s"
    }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.upgradeAssistant.overview.systemIndices.migrationFailedBodyFirstParagraph",
      defaultMessage: "Errors occurred while migrating system indices:"
    }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
      size: "s"
    }), failureCauses, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.upgradeAssistant.overview.systemIndices.migrationFailedBodySecondParagraph",
      defaultMessage: "Check migration details for more information.",
      tagName: "p"
    }));
  }
};
const MigrateSystemIndicesStep = ({
  setIsComplete
}) => {
  var _migrationStatus$data2, _migrationStatus$data3, _migrationStatus$data4, _migrationStatus$data5, _migrationStatus$data6;
  const {
    beginSystemIndicesMigration,
    startMigrationStatus,
    migrationStatus,
    setShowFlyout
  } = (0, _use_migrate_system_indices.useMigrateSystemIndices)();
  (0, _react.useEffect)(() => {
    var _migrationStatus$data;
    setIsComplete(((_migrationStatus$data = migrationStatus.data) === null || _migrationStatus$data === void 0 ? void 0 : _migrationStatus$data.migration_status) === 'NO_MIGRATION_NEEDED');
    // Depending upon setIsComplete would create an infinite loop.
    // eslint-disable-next-line react-hooks/exhaustive-deps
  }, [(_migrationStatus$data2 = migrationStatus.data) === null || _migrationStatus$data2 === void 0 ? void 0 : _migrationStatus$data2.migration_status]);
  if (migrationStatus.error) {
    return /*#__PURE__*/_react.default.createElement(_eui.EuiCallOut, {
      title: i18nTexts.loadingError,
      color: "danger",
      iconType: "warning",
      "data-test-subj": "systemIndicesStatusErrorCallout"
    }, /*#__PURE__*/_react.default.createElement("p", null, migrationStatus.error.statusCode, " - ", migrationStatus.error.message), /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
      color: "danger",
      isLoading: migrationStatus.isLoading,
      onClick: migrationStatus.resendRequest,
      "data-test-subj": "systemIndicesStatusRetryButton"
    }, i18nTexts.retryButtonLabel));
  }
  if (((_migrationStatus$data3 = migrationStatus.data) === null || _migrationStatus$data3 === void 0 ? void 0 : _migrationStatus$data3.migration_status) === 'NO_MIGRATION_NEEDED') {
    return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
      alignItems: "center",
      gutterSize: "s",
      "data-test-subj": "noMigrationNeededSection"
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: false
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
      type: "check",
      color: "success"
    })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: false
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
      color: "success"
    }, /*#__PURE__*/_react.default.createElement("p", null, i18nTexts.noMigrationNeeded))));
  }
  const isButtonDisabled = migrationStatus.isInitialRequest && migrationStatus.isLoading;
  const isMigrating = ((_migrationStatus$data4 = migrationStatus.data) === null || _migrationStatus$data4 === void 0 ? void 0 : _migrationStatus$data4.migration_status) === 'IN_PROGRESS';
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, startMigrationStatus.statusType === 'error' && /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiCallOut, {
    size: "s",
    color: "danger",
    iconType: "warning",
    title: `${startMigrationStatus.error.statusCode} - ${startMigrationStatus.error.message}`,
    "data-test-subj": "startSystemIndicesMigrationCalloutError"
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m"
  })), ((_migrationStatus$data5 = migrationStatus.data) === null || _migrationStatus$data5 === void 0 ? void 0 : _migrationStatus$data5.migration_status) === 'ERROR' && /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiCallOut, {
    size: "s",
    color: "danger",
    iconType: "warning",
    title: i18nTexts.migrationFailedTitle,
    "data-test-subj": "migrationFailedCallout"
  }, i18nTexts.migrationFailedBody((_migrationStatus$data6 = migrationStatus.data) === null || _migrationStatus$data6 === void 0 ? void 0 : _migrationStatus$data6.features)), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m"
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    alignItems: "center",
    gutterSize: "s"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_migrate_button.MigrateSystemIndicesButton, {
    beginSystemIndicesMigration: beginSystemIndicesMigration,
    isInitialRequest: migrationStatus.isInitialRequest,
    isLoading: migrationStatus.isLoading,
    isMigrating: isMigrating
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
    onClick: () => setShowFlyout(true),
    isDisabled: isButtonDisabled,
    "data-test-subj": "viewSystemIndicesStateButton"
  }, i18nTexts.viewSystemIndicesStatus))));
};
const getMigrateSystemIndicesStep = ({
  isComplete,
  setIsComplete,
  docLinks
}) => {
  const status = isComplete ? 'complete' : 'incomplete';
  return {
    title: i18nTexts.title,
    status,
    'data-test-subj': `migrateSystemIndicesStep-${status}`,
    children: /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
      "data-test-subj": "migrateSystemIndicesText"
    }, /*#__PURE__*/_react.default.createElement("p", null, i18nTexts.bodyDescription(docLinks.links.elasticsearch.hiddenIndices))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
      size: "m"
    }), /*#__PURE__*/_react.default.createElement(MigrateSystemIndicesStep, {
      setIsComplete: setIsComplete
    }))
  };
};
exports.getMigrateSystemIndicesStep = getMigrateSystemIndicesStep;