"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.hasIndexWarning = exports.ReplaceIndexWithAliasWarningCheckbox = exports.MakeIndexReadonlyWarningCheckbox = exports.DeprecatedSettingWarningCheckbox = void 0;
var _react = _interopRequireWildcard(require("react"));
var _i18n = require("@kbn/i18n");
var _eui = require("@elastic/eui");
var _react2 = require("@emotion/react");
var _i18nReact = require("@kbn/i18n-react");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const hasIndexWarning = (warnings, warningType) => {
  return Boolean(warnings.find(warning => warning.warningType === warningType));
};
exports.hasIndexWarning = hasIndexWarning;
// Base component for all warning checkboxes
const BaseWarningCheckbox = ({
  id,
  isChecked,
  onChange,
  children
}) => {
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiCheckableCard, {
    id: id,
    checkableType: "checkbox",
    checked: isChecked,
    onChange: onChange,
    label: children
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m"
  }));
};

// Reusable popover component with info button
const InfoPopover = ({
  children
}) => {
  const {
    euiTheme
  } = (0, _eui.useEuiTheme)();
  const [isPopoverOpen, setIsPopoverOpen] = (0, _react.useState)(false);
  const onTogglePopover = () => setIsPopoverOpen(isOpen => !isOpen);
  const popoverId = (0, _eui.useGeneratedHtmlId)();
  const popoverStyles = (0, _react2.css)`
    margin-top: -${euiTheme.size.xs};
  `;
  return /*#__PURE__*/_react.default.createElement(_eui.EuiPopover, {
    button: /*#__PURE__*/_react.default.createElement(_eui.EuiButtonIcon, {
      display: "empty",
      iconType: "info",
      onClick: onTogglePopover,
      css: popoverStyles,
      "aria-labelledby": popoverId
    }),
    isOpen: isPopoverOpen,
    closePopover: () => setIsPopoverOpen(false),
    anchorPosition: "leftCenter"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    size: "s",
    style: {
      width: 300
    },
    id: popoverId
  }, children));
};
const DeprecatedSettingWarningCheckbox = ({
  isChecked,
  onChange,
  docLinks,
  id,
  meta
}) => {
  return /*#__PURE__*/_react.default.createElement(BaseWarningCheckbox, {
    id: id,
    isChecked: isChecked,
    onChange: onChange
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    tagName: "b",
    id: "xpack.upgradeAssistant.esDeprecations.indices.indexFlyout.warningsStep.deprecatedIndexSettingsWarningTitle",
    defaultMessage: "Remove deprecated index settings"
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m"
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    size: "s"
  }, /*#__PURE__*/_react.default.createElement("ul", null, meta.deprecatedSettings.map((setting, index) => {
    return /*#__PURE__*/_react.default.createElement("li", {
      key: `${setting}-${index}`
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiCode, null, setting));
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m"
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
    href: docLinks.elasticsearch.indexModules,
    target: "_blank",
    external: true
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.upgradeAssistant.esDeprecations.indices.indexFlyout.warningsStep.documentationLinkLabel",
    defaultMessage: "Learn more"
  })));
};
exports.DeprecatedSettingWarningCheckbox = DeprecatedSettingWarningCheckbox;
const i18nStrings = {
  index: _i18n.i18n.translate('xpack.upgradeAssistant.esDeprecations.indices.indexFlyout.warningsStep.indexLabel', {
    defaultMessage: 'Index'
  }),
  newIndex: _i18n.i18n.translate('xpack.upgradeAssistant.esDeprecations.indices.indexFlyout.warningsStep.newIndexLabel', {
    defaultMessage: 'New index'
  }),
  alias: _i18n.i18n.translate('xpack.upgradeAssistant.esDeprecations.indices.indexFlyout.warningsStep.aliasLabel', {
    defaultMessage: 'Alias'
  })
};
const ReplaceIndexWithAliasWarningCheckbox = ({
  isChecked,
  onChange,
  id,
  meta
}) => {
  const {
    euiTheme
  } = (0, _eui.useEuiTheme)();
  const textStyles = (0, _react2.css)`
    p {
      word-break: break-all;
      margin-bottom: ${euiTheme.size.s};

      &:last-of-type {
        margin-bottom: 0;
      }
    }
  `;
  return /*#__PURE__*/_react.default.createElement(BaseWarningCheckbox, {
    id: id,
    isChecked: isChecked,
    onChange: onChange
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    gutterSize: "s"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    tagName: "b",
    id: "xpack.upgradeAssistant.esDeprecations.indices.indexFlyout.warningsStep.replaceIndexWithAliasWarningTitle",
    defaultMessage: "Replace index and create alias"
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(InfoPopover, null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    tagName: "p",
    id: "xpack.upgradeAssistant.esDeprecations.indices.indexFlyout.warningsStep.replaceIndexWithAliasWarningDetail",
    defaultMessage: "You can search {indexName} as before. To delete the data you'll have to delete {reindexName}",
    values: {
      indexName: /*#__PURE__*/_react.default.createElement(_eui.EuiCode, null, meta === null || meta === void 0 ? void 0 : meta.indexName),
      reindexName: /*#__PURE__*/_react.default.createElement(_eui.EuiCode, null, meta === null || meta === void 0 ? void 0 : meta.reindexName)
    }
  })))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m"
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    grow: false,
    size: "s",
    css: textStyles
  }, /*#__PURE__*/_react.default.createElement("p", null, i18nStrings.index, ": ", /*#__PURE__*/_react.default.createElement(_eui.EuiCode, null, meta === null || meta === void 0 ? void 0 : meta.indexName)), /*#__PURE__*/_react.default.createElement("p", null, i18nStrings.newIndex, ": ", /*#__PURE__*/_react.default.createElement(_eui.EuiCode, null, meta === null || meta === void 0 ? void 0 : meta.reindexName)), /*#__PURE__*/_react.default.createElement("p", null, i18nStrings.alias, ": ", /*#__PURE__*/_react.default.createElement(_eui.EuiCode, null, meta === null || meta === void 0 ? void 0 : meta.indexName))));
};
exports.ReplaceIndexWithAliasWarningCheckbox = ReplaceIndexWithAliasWarningCheckbox;
const MakeIndexReadonlyWarningCheckbox = ({
  isChecked,
  onChange,
  id,
  meta
}) => {
  return /*#__PURE__*/_react.default.createElement(BaseWarningCheckbox, {
    id: id,
    isChecked: isChecked,
    onChange: onChange
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    gutterSize: "s"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    tagName: "b",
    id: "xpack.upgradeAssistant.esDeprecations.indices.indexFlyout.warningsStep.makeIndexReadonlyWarningTitle",
    defaultMessage: "Set {indexName} index to read-only",
    values: {
      indexName: /*#__PURE__*/_react.default.createElement(_eui.EuiCode, null, meta === null || meta === void 0 ? void 0 : meta.indexName)
    }
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(InfoPopover, null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    tagName: "p",
    id: "xpack.upgradeAssistant.esDeprecations.indices.indexFlyout.warningsStep.makeIndexReadonlyWarningDetail",
    defaultMessage: "You can continue to search and retrieve documents from {indexName}. You will not be able to insert new documents or modify existing ones.",
    values: {
      indexName: /*#__PURE__*/_react.default.createElement(_eui.EuiCode, null, meta === null || meta === void 0 ? void 0 : meta.indexName)
    }
  })))));
};
exports.MakeIndexReadonlyWarningCheckbox = MakeIndexReadonlyWarningCheckbox;