"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ChecklistFlyoutStep = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _i18nReact = require("@kbn/i18n-react");
var _types = require("../../../../../../../../../common/types");
var _types2 = require("../../../../../../types");
var _progress = require("./progress");
var _app_context = require("../../../../../../../app_context");
var _messages = require("../../messages");
var _nodes_low_disk_space = require("../../../../../common/nodes_low_disk_space");
var _callouts = require("./callouts");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

/**
 * Displays a flyout that shows the current reindexing status for a given index.
 */
const ChecklistFlyoutStep = ({
  closeFlyout,
  migrationState,
  executeAction,
  cancelAction,
  dataStreamName
}) => {
  const {
    services: {
      api
    }
  } = (0, _app_context.useAppContext)();
  const {
    loadingState,
    status,
    hasRequiredPrivileges
  } = migrationState;
  const loading = loadingState === _types2.LoadingState.Loading || status === _types.DataStreamMigrationStatus.inProgress;
  const isCompleted = status === _types.DataStreamMigrationStatus.completed;
  const hasFetchFailed = status === _types.DataStreamMigrationStatus.fetchFailed;
  const hasMigrationFailed = status === _types.DataStreamMigrationStatus.failed;
  const {
    data: nodes
  } = api.useLoadNodeDiskSpace();
  const showMainButton = !hasFetchFailed && !isCompleted && hasRequiredPrivileges;
  const shouldShowCancelButton = showMainButton && status === _types.DataStreamMigrationStatus.inProgress;
  return /*#__PURE__*/_react.default.createElement(_react.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlyoutBody, {
    "data-test-subj": "dataStreamMigrationChecklistFlyout"
  }, !hasRequiredPrivileges && /*#__PURE__*/_react.default.createElement(_callouts.NoPrivilegesCallout, null), nodes && nodes.length > 0 && /*#__PURE__*/_react.default.createElement(_nodes_low_disk_space.NodesLowSpaceCallOut, {
    nodes: nodes
  }), (hasFetchFailed || hasMigrationFailed) && /*#__PURE__*/_react.default.createElement(_callouts.FetchFailedCallout, {
    hasFetchFailed: hasFetchFailed,
    errorMessage: migrationState.errorMessage
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiText, null, /*#__PURE__*/_react.default.createElement("p", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    defaultMessage: "Reindexing is performed in the background. You can return to the Upgrade Assistant to view progress.",
    id: "xpack.upgradeAssistant.dataStream.migration.flyout.checklistStep.readonlyCallout.backgroundResumeDetail"
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, null), /*#__PURE__*/_react.default.createElement(_progress.MigrationProgress, {
    migrationState: migrationState,
    dataStreamName: dataStreamName
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlyoutFooter, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    justifyContent: "spaceBetween"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
    iconType: "cross",
    onClick: closeFlyout,
    flush: "left",
    "data-test-subj": "closeDataStreamReindexingButton"
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.upgradeAssistant.dataStream.migration.flyout.checklistStep.closeButtonLabel",
    defaultMessage: "Close"
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    gutterSize: "s"
  }, shouldShowCancelButton && /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
    color: 'accent',
    iconType: 'pause',
    onClick: cancelAction,
    disabled: !hasRequiredPrivileges,
    "data-test-subj": "cancelDataStreamMigrationButton"
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.upgradeAssistant.dataStream.migration.flyout.checklistStep.cancelMigrationButtonLabel",
    defaultMessage: "Cancel reindexing"
  }))), showMainButton && /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
    fill: true,
    color: 'primary',
    iconType: status === _types.DataStreamMigrationStatus.inProgress ? undefined : 'refresh',
    onClick: executeAction,
    isLoading: loading,
    disabled: loading || !hasRequiredPrivileges,
    "data-test-subj": "startDataStreamMigrationButton"
  }, (0, _messages.getPrimaryButtonLabel)(status))))))));
};
exports.ChecklistFlyoutStep = ChecklistFlyoutStep;