"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.NodesLowSpaceCallOut = void 0;
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
var _i18nReact = require("@kbn/i18n-react");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const NodesLowSpaceCallOut = ({
  nodes
}) => {
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiCallOut, {
    color: "warning",
    iconType: "warning",
    "data-test-subj": "lowDiskSpaceCallout",
    title: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.upgradeAssistant.common.warning.lowDiskSpaceCalloutTitle",
      defaultMessage: "Nodes with low disk space"
    })
  }, /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.upgradeAssistant.common.warning.lowDiskSpaceCalloutDescription",
    defaultMessage: "Disk usage has exceeded the low watermark, which may prevent migration. The following nodes are impacted:"
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "s"
  }), /*#__PURE__*/_react.default.createElement("ul", null, nodes.map(({
    nodeName,
    available,
    nodeId
  }) => /*#__PURE__*/_react.default.createElement("li", {
    key: nodeId,
    "data-test-subj": "impactedNodeListItem"
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.upgradeAssistant.common.warning.lowDiskSpaceUsedText",
    defaultMessage: "{nodeName} ({available} available)",
    values: {
      nodeName,
      available
    }
  })))))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m"
  }));
};
exports.NodesLowSpaceCallOut = NodesLowSpaceCallOut;