"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.searchBarStyles = void 0;
var _react = require("@emotion/react");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

const searchBarStyles = ({
  euiTheme
}, isESQLQuery) => {
  return {
    uniSearchBar: (0, _react.css)`
      padding: ${isESQLQuery ? 0 : euiTheme.size.s};
      position: relative;
    `,
    detached: (0, _react.css)`
      border-bottom: ${euiTheme.border.thin};
    `,
    inPage: (0, _react.css)`
      padding: 0;
    `,
    withBorders: (0, _react.css)`
      border: ${euiTheme.border.thin};
      border-bottom: none;
    `,
    hidden: (0, _react.css)`
      display: none;
    `
  };
};
exports.searchBarStyles = searchBarStyles;