"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.SavedQueryManagementList = void 0;
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _react = _interopRequireWildcard(require("react"));
var _server = require("react-dom/server");
var _public = require("@kbn/kibana-react-plugin/public");
require("./saved_query_management_list.scss");
var _uiTheme = require("@kbn/ui-theme");
var _lodash = require("lodash");
var _useLatest = _interopRequireDefault(require("react-use/lib/useLatest"));
var _reactKibanaContextRender = require("@kbn/react-kibana-context-render");
var _query_bar_menu_panels = require("../query_string_input/query_bar_menu_panels");
var _panel_title = require("../query_string_input/panel_title");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

const commonDurationRanges = [{
  start: 'now/d',
  end: 'now/d',
  label: _i18n.i18n.translate('unifiedSearch.search.searchBar.savedQueryTodayLabel', {
    defaultMessage: 'Today'
  })
}, {
  start: 'now/w',
  end: 'now/w',
  label: _i18n.i18n.translate('unifiedSearch.search.searchBar.savedQueryWeekLabel', {
    defaultMessage: 'This week'
  })
}, {
  start: 'now/M',
  end: 'now/M',
  label: _i18n.i18n.translate('unifiedSearch.search.searchBar.savedQueryMonthLabel', {
    defaultMessage: 'This month'
  })
}, {
  start: 'now/y',
  end: 'now/y',
  label: _i18n.i18n.translate('unifiedSearch.search.searchBar.savedQueryYearLabel', {
    defaultMessage: 'This year'
  })
}, {
  start: 'now-1d/d',
  end: 'now-1d/d',
  label: _i18n.i18n.translate('unifiedSearch.searchBar.savedQueryYesterdayLabel', {
    defaultMessage: 'Yesterday'
  })
}, {
  start: 'now/w',
  end: 'now',
  label: _i18n.i18n.translate('unifiedSearch.searchBar.savedQueryWeekToDateLabel', {
    defaultMessage: 'Week to date'
  })
}, {
  start: 'now/M',
  end: 'now',
  label: _i18n.i18n.translate('unifiedSearch.searchBar.savedQueryMonthToDateLabel', {
    defaultMessage: 'Month to date'
  })
}, {
  start: 'now/y',
  end: 'now',
  label: _i18n.i18n.translate('unifiedSearch.searchBar.savedQueryYearToDateLabel', {
    defaultMessage: 'Year to date'
  })
}];
const itemTitle = (attributes, services) => {
  const label = [attributes.title];
  if (attributes.description) {
    label.push(attributes.description);
  }
  if (attributes.timefilter) {
    label.push(
    // This is a hack to render the PrettyDuration component to a string since itemTitle
    // is called in a loop, so the usePrettyDuration hook is not an option, and it must
    // return a string, but there is no non-hook alternative that returns a string
    (0, _server.renderToStaticMarkup)(/*#__PURE__*/_react.default.createElement(_reactKibanaContextRender.KibanaRenderContextProvider, services, /*#__PURE__*/_react.default.createElement(_eui.PrettyDuration, {
      timeFrom: attributes.timefilter.from,
      timeTo: attributes.timefilter.to,
      quickRanges: commonDurationRanges,
      dateFormat: services.uiSettings.get('dateFormat')
    }))));
  }
  return label.join('; ');
};
const itemLabel = attributes => {
  let label = attributes.title;
  if (attributes.description) {
    label = /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, label, " ", /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
      type: "info",
      color: "subdued",
      size: "s"
    }));
  }
  if (attributes.timefilter) {
    label = /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, label, " ", /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
      type: "clock",
      color: "subdued",
      size: "s"
    }));
  }
  return label;
};
const noSavedQueriesDescriptionText = [_i18n.i18n.translate('unifiedSearch.search.searchBar.savedQueryNoSavedQueriesText', {
  defaultMessage: 'No saved queries.'
}), _i18n.i18n.translate('unifiedSearch.search.searchBar.savedQueryDescriptionText', {
  defaultMessage: 'Save query text and filters that you want to use again.'
})].join(' ');
const savedQueryMultipleNamespacesDeleteWarning = _i18n.i18n.translate('unifiedSearch.search.searchBar.savedQueryMultipleNamespacesDeleteWarning', {
  defaultMessage: `This saved query is shared in multiple spaces. When you delete it, you remove it from every space it is shared in. You can't undo this action.`
});
const SAVED_QUERY_PAGE_SIZE = 5;
const SAVED_QUERY_SEARCH_DEBOUNCE = 500;
const LOADING_INDICATOR_DELAY = 250;
const SavedQueryManagementList = ({
  showSaveQuery,
  loadedSavedQuery,
  savedQueryService,
  queryBarMenuRef,
  onLoad,
  onClearSavedQuery,
  onClose
}) => {
  const services = (0, _public.useKibana)().services;
  const [searchTerm, setSearchTerm] = (0, _react.useState)('');
  const [currentPageNumber, setCurrentPageNumber] = (0, _react.useState)(0);
  const [totalQueryCount, setTotalQueryCount] = (0, _react.useState)(0);
  const [currentPageQueries, setCurrentPageQueries] = (0, _react.useState)([]);
  const [isLoading, setIsLoading] = (0, _react.useState)(false);
  const [isInitializing, setIsInitializing] = (0, _react.useState)(true);
  const currentPageFetchId = (0, _react.useRef)(0);
  const selectableRef = (0, _react.useRef)(null);
  const [selectedSavedQuery, setSelectedSavedQuery] = (0, _react.useState)(loadedSavedQuery);
  const [toBeDeletedSavedQuery, setToBeDeletedSavedQuery] = (0, _react.useState)(null);
  const [showDeletionConfirmationModal, setShowDeletionConfirmationModal] = (0, _react.useState)(false);
  const debouncedSetSearchTerm = (0, _react.useMemo)(() => {
    return (0, _lodash.debounce)(newSearchTerm => {
      setSearchTerm(currentSearchTerm => {
        if (currentSearchTerm !== newSearchTerm) {
          setCurrentPageNumber(0);
        }
        return newSearchTerm;
      });
    }, SAVED_QUERY_SEARCH_DEBOUNCE);
  }, []);
  const fetchPage = (0, _useLatest.default)(async () => {
    const fetchIdValue = ++currentPageFetchId.current;
    const loadingTimeout = setTimeout(() => {
      setIsLoading(true);
    }, LOADING_INDICATOR_DELAY);
    try {
      var _selectableRef$curren;
      const preparedSearch = searchTerm.trim();
      const {
        total,
        queries
      } = await savedQueryService.findSavedQueries(preparedSearch || undefined, SAVED_QUERY_PAGE_SIZE, currentPageNumber + 1);
      if (fetchIdValue !== currentPageFetchId.current) {
        return;
      }
      let filteredQueries = queries;
      if (loadedSavedQuery && !preparedSearch && currentPageNumber === 0) {
        filteredQueries = [loadedSavedQuery, ...queries.filter(savedQuery => savedQuery.id !== loadedSavedQuery.id)];
      }
      setTotalQueryCount(total);
      setCurrentPageQueries(filteredQueries);
      (_selectableRef$curren = selectableRef.current) === null || _selectableRef$curren === void 0 ? void 0 : _selectableRef$curren.scrollToItem(0);
    } finally {
      clearTimeout(loadingTimeout);
      if (fetchIdValue === currentPageFetchId.current) {
        setIsLoading(false);
        setIsInitializing(false);
      }
    }
  });
  (0, _react.useEffect)(() => {
    fetchPage.current();
  }, [currentPageNumber, fetchPage, searchTerm]);
  const handleLoad = (0, _react.useCallback)(() => {
    if (selectedSavedQuery) {
      onLoad(selectedSavedQuery);
      onClose();
    }
  }, [onLoad, selectedSavedQuery, onClose]);
  const handleSelect = (0, _react.useCallback)(choices => {
    const choice = choices.find(({
      checked
    }) => checked);
    if (choice) {
      setSelectedSavedQuery(currentPageQueries.find(savedQuery => savedQuery.id === choice.value));
    }
  }, [currentPageQueries]);
  const handleDelete = (0, _react.useCallback)(savedQueryToDelete => {
    setShowDeletionConfirmationModal(true);
    setToBeDeletedSavedQuery(savedQueryToDelete);
  }, []);
  const onDelete = (0, _react.useCallback)(savedQueryToDelete => {
    const onDeleteSavedQuery = async savedQueryId => {
      setTotalQueryCount(currentTotalQueryCount => Math.max(0, currentTotalQueryCount - 1));
      setCurrentPageQueries(currentPageQueries.filter(currentSavedQuery => currentSavedQuery.id !== savedQueryId));
      setSelectedSavedQuery(undefined);
      if (loadedSavedQuery && loadedSavedQuery.id === savedQueryId) {
        onClearSavedQuery();
      }
      try {
        await savedQueryService.deleteSavedQuery(savedQueryId);
        services.notifications.toasts.addSuccess(_i18n.i18n.translate('unifiedSearch.search.searchBar.deleteQuerySuccessMessage', {
          defaultMessage: 'Query "{queryTitle}" was deleted',
          values: {
            queryTitle: savedQueryToDelete.attributes.title
          }
        }));
      } catch (error) {
        services.notifications.toasts.addDanger(_i18n.i18n.translate('unifiedSearch.search.searchBar.deleteQueryErrorMessage', {
          defaultMessage: 'An error occured while deleting query "{queryTitle}": {errorMessage}',
          values: {
            queryTitle: savedQueryToDelete.attributes.title,
            errorMessage: error.message
          }
        }));
        throw error;
      }
    };
    onDeleteSavedQuery(savedQueryToDelete.id);
  }, [currentPageQueries, loadedSavedQuery, onClearSavedQuery, savedQueryService, services.notifications.toasts]);
  const savedQueriesOptions = (0, _react.useMemo)(() => {
    return currentPageQueries.map(savedQuery => {
      return {
        key: savedQuery.id,
        label: savedQuery.attributes.title,
        title: itemTitle(savedQuery.attributes, services),
        'data-test-subj': `load-saved-query-${savedQuery.attributes.title}-button`,
        value: savedQuery.id,
        checked: selectedSavedQuery && savedQuery.id === selectedSavedQuery.id ? 'on' : undefined,
        data: {
          attributes: savedQuery.attributes
        }
      };
    });
  }, [currentPageQueries, selectedSavedQuery, services]);
  const renderOption = (0, _react.useCallback)(option => {
    return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, option.attributes ? itemLabel(option.attributes) : option.label, option.value === (loadedSavedQuery === null || loadedSavedQuery === void 0 ? void 0 : loadedSavedQuery.id) && /*#__PURE__*/_react.default.createElement(_eui.EuiBadge, {
      color: "hollow",
      css: {
        marginLeft: _uiTheme.euiThemeVars.euiSizeS
      }
    }, _i18n.i18n.translate('unifiedSearch.search.searchBar.savedQueryActiveBadgeText', {
      defaultMessage: 'Active'
    })));
  }, [loadedSavedQuery === null || loadedSavedQuery === void 0 ? void 0 : loadedSavedQuery.id]);
  const countDisplay = (0, _react.useMemo)(() => {
    const parts = [_i18n.i18n.translate('unifiedSearch.search.searchBar.savedQueryTotalQueryCount', {
      defaultMessage: '{totalQueryCount, plural, one {# query} other {# queries}}',
      values: {
        totalQueryCount
      }
    })];
    if (Boolean(selectedSavedQuery)) {
      parts.push(_i18n.i18n.translate('unifiedSearch.search.searchBar.savedQuerySelectedQueryCount', {
        defaultMessage: '1 selected'
      }));
    }
    return parts.join(' | ');
  }, [selectedSavedQuery, totalQueryCount]);
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(ListTitle, {
    queryBarMenuRef: queryBarMenuRef
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    direction: "column",
    gutterSize: "none",
    responsive: false,
    className: "kbnSavedQueryManagement__listWrapper",
    "data-test-subj": "saved-query-management-list"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    css: {
      position: 'relative'
    }
  }, isLoading && /*#__PURE__*/_react.default.createElement(_eui.EuiProgress, {
    size: "xs",
    color: "accent",
    position: "absolute"
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiSelectable, {
    ref: selectableRef,
    "aria-label": _i18n.i18n.translate('unifiedSearch.search.searchBar.savedQueryListAriaLabel', {
      defaultMessage: 'Query list'
    }),
    isLoading: isInitializing,
    singleSelection: "always",
    options: savedQueriesOptions,
    listProps: {
      onFocusBadge: false
    },
    isPreFiltered: true,
    searchable: true,
    searchProps: {
      compressed: true,
      placeholder: _i18n.i18n.translate('unifiedSearch.query.queryBar.indexPattern.findFilterSet', {
        defaultMessage: 'Find a query'
      }),
      onChange: debouncedSetSearchTerm,
      'data-test-subj': 'saved-query-management-search-input'
    },
    loadingMessage: _i18n.i18n.translate('unifiedSearch.search.searchBar.savedQueryLoadingQueriesText', {
      defaultMessage: 'Loading queries'
    }),
    emptyMessage: /*#__PURE__*/_react.default.createElement("span", {
      "data-test-subj": "saved-query-management-empty"
    }, noSavedQueriesDescriptionText),
    onChange: handleSelect,
    renderOption: renderOption,
    css: {
      '.euiSelectableList__list': {
        WebkitMaskImage: 'unset',
        maskImage: 'unset'
      }
    }
  }, (list, search) => /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiPanel, {
    color: "transparent",
    paddingSize: "s",
    css: {
      paddingBottom: 0
    }
  }, search), /*#__PURE__*/_react.default.createElement(_eui.EuiPanel, {
    color: "transparent",
    paddingSize: "s"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    size: "xs",
    color: "subdued"
  }, countDisplay)), /*#__PURE__*/_react.default.createElement(_eui.EuiHorizontalRule, {
    margin: "none"
  }), list))), totalQueryCount > SAVED_QUERY_PAGE_SIZE && /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    css: {
      padding: _uiTheme.euiThemeVars.euiSizeS
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    responsive: false,
    justifyContent: "center"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiPagination, {
    pageCount: Math.ceil(totalQueryCount / SAVED_QUERY_PAGE_SIZE),
    activePage: currentPageNumber,
    onPageClick: activePage => setCurrentPageNumber(activePage),
    compressed: true
  }))))), /*#__PURE__*/_react.default.createElement(_eui.EuiPopoverFooter, {
    paddingSize: "s",
    css: {
      backgroundColor: _uiTheme.euiThemeVars.euiColorLightestShade
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    responsive: false,
    gutterSize: "xs",
    alignItems: "center",
    justifyContent: "spaceBetween"
  }, Boolean(showSaveQuery) && /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiToolTip, {
    position: "top",
    content: selectedSavedQuery ? _i18n.i18n.translate('unifiedSearch.search.searchBar.savedQueryDelete', {
      defaultMessage: 'Delete query'
    }) : _i18n.i18n.translate('unifiedSearch.search.searchBar.savedQuerySelectionRequired', {
      defaultMessage: 'You need to select a query first'
    })
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonIcon, {
    display: "base",
    size: "s",
    iconType: "trash",
    color: "danger",
    disabled: !selectedSavedQuery,
    "aria-label": _i18n.i18n.translate('unifiedSearch.search.searchBar.savedQueryDelete', {
      defaultMessage: 'Delete query'
    }),
    "data-test-subj": "delete-saved-query-button",
    onClick: () => {
      if (selectedSavedQuery) {
        handleDelete(selectedSavedQuery);
      }
    }
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiToolTip, {
    position: "top",
    content: !selectedSavedQuery && _i18n.i18n.translate('unifiedSearch.search.searchBar.savedQuerySelectionRequired', {
      defaultMessage: 'You need to select a query first'
    })
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
    size: "s",
    fill: true,
    onClick: handleLoad,
    disabled: !selectedSavedQuery,
    "aria-label": _i18n.i18n.translate('unifiedSearch.search.searchBar.savedQueryPopoverApplyFilterSetLabel', {
      defaultMessage: 'Load query'
    }),
    "data-test-subj": "saved-query-management-apply-changes-button"
  }, _i18n.i18n.translate('unifiedSearch.search.searchBar.savedQueryPopoverApplyFilterSetLabel', {
    defaultMessage: 'Load query'
  })))))), showDeletionConfirmationModal && toBeDeletedSavedQuery && /*#__PURE__*/_react.default.createElement(_eui.EuiConfirmModal, {
    title: _i18n.i18n.translate('unifiedSearch.search.searchBar.savedQueryPopoverConfirmDeletionTitle', {
      defaultMessage: 'Delete "{savedQueryName}"?',
      values: {
        savedQueryName: toBeDeletedSavedQuery.attributes.title
      }
    }),
    confirmButtonText: _i18n.i18n.translate('unifiedSearch.search.searchBar.savedQueryPopoverConfirmDeletionConfirmButtonText', {
      defaultMessage: 'Delete'
    }),
    cancelButtonText: _i18n.i18n.translate('unifiedSearch.search.searchBar.savedQueryPopoverConfirmDeletionCancelButtonText', {
      defaultMessage: 'Cancel'
    }),
    onConfirm: () => {
      onDelete(toBeDeletedSavedQuery);
      setShowDeletionConfirmationModal(false);
    },
    buttonColor: "danger",
    onCancel: () => {
      setShowDeletionConfirmationModal(false);
    }
  }, toBeDeletedSavedQuery.namespaces.length > 1 || toBeDeletedSavedQuery.namespaces.includes('*') ? savedQueryMultipleNamespacesDeleteWarning : null));
};
exports.SavedQueryManagementList = SavedQueryManagementList;
const ListTitle = ({
  queryBarMenuRef
}) => {
  const {
    application,
    http
  } = (0, _public.useKibana)().services;
  const canEditSavedObjects = application.capabilities.savedObjectsManagement.edit;
  return /*#__PURE__*/_react.default.createElement(_panel_title.PanelTitle, {
    queryBarMenuRef: queryBarMenuRef,
    title: _query_bar_menu_panels.strings.getLoadCurrentFilterSetLabel(),
    append: canEditSavedObjects && /*#__PURE__*/_react.default.createElement(_eui.EuiToolTip, {
      position: "bottom",
      content: _i18n.i18n.translate('unifiedSearch.search.searchBar.savedQueryPopoverManageLabel', {
        defaultMessage: 'Manage queries'
      })
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonIcon, {
      iconType: "gear",
      color: "text",
      href: http.basePath.prepend(`/app/management/kibana/objects?initialQuery=type:("query")`),
      "aria-label": _i18n.i18n.translate('unifiedSearch.search.searchBar.savedQueryPopoverManageLabel', {
        defaultMessage: 'Manage queries'
      })
    }))
  });
};