"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.fetchIndexPatterns = fetchIndexPatterns;
var _lodash = require("lodash");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

async function fetchIndexPatterns(indexPatternsService, indexPatternStrings) {
  if (!indexPatternStrings || (0, _lodash.isEmpty)(indexPatternStrings)) {
    return [];
  }
  const searchStringList = [];
  const searchIdsList = [];
  for (const {
    type,
    value
  } of indexPatternStrings) {
    if (type === 'title') {
      searchStringList.push(value);
    } else {
      searchIdsList.push(value);
    }
  }
  const searchString = searchStringList.map(value => `"${value}"`).join(' | ');
  const [searchMatches, ...matchesById] = await Promise.all([indexPatternsService.find(searchString), ...searchIdsList.map(id => indexPatternsService.get(id))]);
  const exactMatches = [...searchMatches.filter(ip => searchStringList.includes(ip.title)), ...matchesById];
  const allMatches = exactMatches.length === indexPatternStrings.length ? exactMatches : [...exactMatches, await indexPatternsService.getDefault()];
  return allMatches.filter(d => d != null);
}