"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.sortPrefixFirst = sortPrefixFirst;
var _lodash = require("lodash");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

function sortPrefixFirst(array, prefix, property) {
  if (!prefix) {
    return array;
  }
  const lowerCasePrefix = ('' + prefix).toLowerCase();
  const partitions = (0, _lodash.partition)(array, entry => {
    const value = ('' + (property ? entry[property] : entry)).toLowerCase();
    return value.startsWith(lowerCasePrefix);
  });
  return [...partitions[0], ...partitions[1]];
}