"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.UnifiedHistogramLayout = void 0;
var _eui = require("@elastic/eui");
var _react = _interopRequireWildcard(require("react"));
var _useObservable = _interopRequireDefault(require("react-use/lib/useObservable"));
var _reactReversePortal = require("react-reverse-portal");
var _css = require("@emotion/css");
var _useLatest = _interopRequireDefault(require("react-use/lib/useLatest"));
var _lodash = require("lodash");
var _resizableLayout = require("@kbn/resizable-layout");
var _chart = require("../chart");
var _types = require("../types");
var _lens_vis_service = require("../services/lens_vis_service");
var _use_request_params = require("../hooks/use_request_params");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

const ChartMemoized = /*#__PURE__*/_react.default.memo(_chart.Chart);
const chartSpacer = /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
  size: "s"
});
const UnifiedHistogramLayout = ({
  className,
  services,
  dataView,
  query: originalQuery,
  filters: originalFilters,
  externalVisContext,
  isChartLoading,
  isPlainRecord,
  timeRange: originalTimeRange,
  relativeTimeRange,
  columns,
  request,
  hits,
  lensAdapters,
  dataLoading$,
  chart: originalChart,
  breakdown,
  container,
  topPanelHeight,
  renderCustomChartToggleActions,
  disableTriggers,
  disabledActions,
  lensSuggestionsApi,
  input$,
  table,
  onTopPanelHeightChange,
  onChartHiddenChange,
  onTimeIntervalChange,
  onBreakdownFieldChange,
  onSuggestionContextChange,
  onVisContextChanged,
  onTotalHitsChange,
  onChartLoad,
  onFilter,
  onBrushEnd,
  children,
  withDefaultActions,
  abortController,
  getModifiedVisAttributes
}) => {
  const columnsMap = (0, _react.useMemo)(() => {
    if (!(columns !== null && columns !== void 0 && columns.length)) {
      return undefined;
    }
    return columns.reduce((acc, column) => {
      acc[column.id] = column;
      return acc;
    }, {});
  }, [columns]);
  const requestParams = (0, _use_request_params.useRequestParams)({
    services,
    query: originalQuery,
    filters: originalFilters,
    timeRange: originalTimeRange
  });
  const [lensVisService] = (0, _react.useState)(() => new _lens_vis_service.LensVisService({
    services,
    lensSuggestionsApi
  }));
  const lensVisServiceCurrentSuggestionContext = (0, _useObservable.default)(lensVisService.currentSuggestionContext$);
  const latestGetModifiedVisAttributes = (0, _useLatest.default)(getModifiedVisAttributes);
  const originalChartTimeInterval = originalChart === null || originalChart === void 0 ? void 0 : originalChart.timeInterval;
  (0, _react.useEffect)(() => {
    if (isChartLoading) {
      return;
    }
    lensVisService.update({
      externalVisContext,
      queryParams: {
        dataView,
        query: requestParams.query,
        filters: requestParams.filters,
        timeRange: originalTimeRange,
        isPlainRecord,
        columns,
        columnsMap
      },
      timeInterval: originalChartTimeInterval,
      breakdownField: breakdown === null || breakdown === void 0 ? void 0 : breakdown.field,
      table,
      onSuggestionContextChange,
      onVisContextChanged: isPlainRecord ? onVisContextChanged : undefined,
      getModifiedVisAttributes: attributes => {
        var _latestGetModifiedVis, _latestGetModifiedVis2;
        return (_latestGetModifiedVis = (_latestGetModifiedVis2 = latestGetModifiedVisAttributes.current) === null || _latestGetModifiedVis2 === void 0 ? void 0 : _latestGetModifiedVis2.call(latestGetModifiedVisAttributes, (0, _lodash.cloneDeep)(attributes))) !== null && _latestGetModifiedVis !== void 0 ? _latestGetModifiedVis : attributes;
      }
    });
  }, [latestGetModifiedVisAttributes, lensVisService, dataView, requestParams.query, requestParams.filters, originalTimeRange, originalChartTimeInterval, isPlainRecord, columns, columnsMap, breakdown, externalVisContext, onSuggestionContextChange, onVisContextChanged, isChartLoading, table]);
  const chart = !(lensVisServiceCurrentSuggestionContext !== null && lensVisServiceCurrentSuggestionContext !== void 0 && lensVisServiceCurrentSuggestionContext.type) || lensVisServiceCurrentSuggestionContext.type === _types.UnifiedHistogramSuggestionType.unsupported ? undefined : originalChart;
  const isChartAvailable = (0, _chart.checkChartAvailability)({
    chart,
    dataView,
    isPlainRecord
  });
  const [topPanelNode] = (0, _react.useState)(() => (0, _reactReversePortal.createHtmlPortalNode)({
    attributes: {
      class: 'eui-fullHeight'
    }
  }));
  const [mainPanelNode] = (0, _react.useState)(() => (0, _reactReversePortal.createHtmlPortalNode)({
    attributes: {
      class: 'eui-fullHeight'
    }
  }));
  const isMobile = (0, _eui.useIsWithinBreakpoints)(['xs', 's']);
  const showFixedPanels = isMobile || !chart || chart.hidden;
  const {
    euiTheme
  } = (0, _eui.useEuiTheme)();
  const defaultTopPanelHeight = euiTheme.base * 12;
  const minMainPanelHeight = euiTheme.base * 10;
  const chartClassName = isMobile && chart && !chart.hidden ? (0, _css.css)`
          height: ${defaultTopPanelHeight}px;
        ` : 'eui-fullHeight';
  const panelsMode = chart || hits ? showFixedPanels ? _resizableLayout.ResizableLayoutMode.Static : _resizableLayout.ResizableLayoutMode.Resizable : _resizableLayout.ResizableLayoutMode.Single;
  const currentTopPanelHeight = topPanelHeight !== null && topPanelHeight !== void 0 ? topPanelHeight : defaultTopPanelHeight;
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_reactReversePortal.InPortal, {
    node: topPanelNode
  }, /*#__PURE__*/_react.default.createElement(ChartMemoized, {
    abortController: abortController,
    isChartAvailable: isChartAvailable,
    className: chartClassName,
    services: services,
    dataView: dataView,
    requestParams: requestParams,
    relativeTimeRange: relativeTimeRange,
    request: request,
    hits: hits,
    lensVisService: lensVisService,
    isChartLoading: isChartLoading,
    isPlainRecord: isPlainRecord,
    chart: chart,
    breakdown: breakdown,
    renderCustomChartToggleActions: renderCustomChartToggleActions,
    appendHistogram: chartSpacer,
    disableTriggers: disableTriggers,
    disabledActions: disabledActions,
    input$: input$,
    onChartHiddenChange: onChartHiddenChange,
    onTimeIntervalChange: onTimeIntervalChange,
    onBreakdownFieldChange: onBreakdownFieldChange,
    onTotalHitsChange: onTotalHitsChange,
    onChartLoad: onChartLoad,
    onFilter: onFilter,
    onBrushEnd: onBrushEnd,
    lensAdapters: lensAdapters,
    dataLoading$: dataLoading$,
    withDefaultActions: withDefaultActions,
    columns: columns
  })), /*#__PURE__*/_react.default.createElement(_reactReversePortal.InPortal, {
    node: mainPanelNode
  }, /*#__PURE__*/_react.default.isValidElement(children) ?
  /*#__PURE__*/
  // @ts-expect-error upgrade typescript v4.9.5
  _react.default.cloneElement(children, {
    isChartAvailable
  }) : children), /*#__PURE__*/_react.default.createElement(_resizableLayout.ResizableLayout, {
    className: className,
    mode: panelsMode,
    direction: _resizableLayout.ResizableLayoutDirection.Vertical,
    container: container,
    fixedPanelSize: currentTopPanelHeight,
    minFixedPanelSize: defaultTopPanelHeight,
    minFlexPanelSize: minMainPanelHeight,
    fixedPanel: /*#__PURE__*/_react.default.createElement(_reactReversePortal.OutPortal, {
      node: topPanelNode
    }),
    flexPanel: /*#__PURE__*/_react.default.createElement(_reactReversePortal.OutPortal, {
      node: mainPanelNode
    }),
    "data-test-subj": "unifiedHistogram",
    onFixedPanelSizeChange: onTopPanelHeightChange
  }));
};
exports.UnifiedHistogramLayout = UnifiedHistogramLayout;