"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useLensProps = exports.getLensProps = void 0;
var _react = require("react");
var _use_stable_callback = require("../../hooks/use_stable_callback");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

const useLensProps = ({
  request,
  getTimeRange,
  fetch$,
  visContext,
  onLoad
}) => {
  const buildLensProps = (0, _react.useCallback)(() => {
    if (!visContext) {
      return;
    }
    const {
      attributes,
      requestData
    } = visContext;
    return {
      requestData: JSON.stringify(requestData),
      lensProps: getLensProps({
        searchSessionId: request === null || request === void 0 ? void 0 : request.searchSessionId,
        getTimeRange,
        attributes,
        onLoad
      })
    };
  }, [visContext, getTimeRange, onLoad, request === null || request === void 0 ? void 0 : request.searchSessionId]);

  // Initialize with undefined to avoid rendering Lens until a fetch has been triggered
  const [lensPropsContext, setLensPropsContext] = (0, _react.useState)();
  const updateLensPropsContext = (0, _use_stable_callback.useStableCallback)(() => setLensPropsContext(buildLensProps()));
  (0, _react.useEffect)(() => {
    const subscription = fetch$.subscribe(updateLensPropsContext);
    return () => subscription.unsubscribe();
  }, [fetch$, updateLensPropsContext]);
  return lensPropsContext;
};
exports.useLensProps = useLensProps;
const getLensProps = ({
  searchSessionId,
  getTimeRange,
  attributes,
  onLoad
}) => ({
  id: 'unifiedHistogramLensComponent',
  viewMode: 'view',
  timeRange: getTimeRange(),
  attributes,
  noPadding: true,
  searchSessionId,
  executionContext: {
    description: 'fetch chart data and total hits'
  },
  onLoad
});
exports.getLensProps = getLensProps;