"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useChartActions = void 0;
var _react = require("react");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

const useChartActions = ({
  chart,
  onChartHiddenChange
}) => {
  const chartRef = (0, _react.useRef)({
    element: null,
    moveFocus: false
  });
  (0, _react.useEffect)(() => {
    if (chartRef.current.moveFocus && chartRef.current.element) {
      chartRef.current.element.focus();
    }
  }, [chart === null || chart === void 0 ? void 0 : chart.hidden]);
  const toggleHideChart = (0, _react.useCallback)(() => {
    const chartHidden = !(chart !== null && chart !== void 0 && chart.hidden);
    chartRef.current.moveFocus = !chartHidden;
    onChartHiddenChange === null || onChartHiddenChange === void 0 ? void 0 : onChartHiddenChange(chartHidden);
  }, [chart === null || chart === void 0 ? void 0 : chart.hidden, onChartHiddenChange]);
  return {
    chartRef,
    toggleHideChart
  };
};
exports.useChartActions = useChartActions;