"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.Chart = Chart;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _react = _interopRequireWildcard(require("react"));
var _rxjs = require("rxjs");
var _useObservable = _interopRequireDefault(require("react-use/lib/useObservable"));
var _sharedUxButtonToolbar = require("@kbn/shared-ux-button-toolbar");
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _public = require("@kbn/inspector-plugin/public");
var _histogram = require("./histogram");
var _types = require("../types");
var _breakdown_field_selector = require("./breakdown_field_selector");
var _time_interval_selector = require("./time_interval_selector");
var _use_total_hits = require("./hooks/use_total_hits");
var _use_chart_styles = require("./hooks/use_chart_styles");
var _use_chart_actions = require("./hooks/use_chart_actions");
var _chart_config_panel = require("./chart_config_panel");
var _use_fetch = require("./hooks/use_fetch");
var _use_edit_visualization = require("./hooks/use_edit_visualization");
var _lens_vis_from_table = require("../utils/lens_vis_from_table");
var _use_lens_props = require("./hooks/use_lens_props");
var _use_stable_callback = require("../hooks/use_stable_callback");
var _build_bucket_interval = require("./utils/build_bucket_interval");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

const HistogramMemoized = /*#__PURE__*/(0, _react.memo)(_histogram.Histogram);
function Chart({
  isChartAvailable,
  className,
  services,
  dataView,
  requestParams,
  relativeTimeRange: originalRelativeTimeRange,
  request,
  hits,
  chart,
  breakdown,
  lensVisService,
  isPlainRecord,
  renderCustomChartToggleActions,
  appendHistogram,
  disableTriggers,
  disabledActions,
  input$: originalInput$,
  lensAdapters,
  dataLoading$,
  isChartLoading,
  onChartHiddenChange,
  onTimeIntervalChange,
  onBreakdownFieldChange,
  onTotalHitsChange,
  onChartLoad,
  onFilter,
  onBrushEnd,
  withDefaultActions,
  abortController,
  columns
}) {
  var _services$capabilitie;
  const lensVisServiceCurrentSuggestionContext = (0, _useObservable.default)(lensVisService.currentSuggestionContext$);
  const visContext = (0, _useObservable.default)(lensVisService.visContext$);
  const currentSuggestion = lensVisServiceCurrentSuggestionContext === null || lensVisServiceCurrentSuggestionContext === void 0 ? void 0 : lensVisServiceCurrentSuggestionContext.suggestion;
  const [isSaveModalVisible, setIsSaveModalVisible] = (0, _react.useState)(false);
  const [isFlyoutVisible, setIsFlyoutVisible] = (0, _react.useState)(false);
  const {
    chartRef,
    toggleHideChart
  } = (0, _use_chart_actions.useChartActions)({
    chart,
    onChartHiddenChange
  });
  const chartVisible = isChartAvailable && !!chart && !chart.hidden && !!visContext && !!(visContext !== null && visContext !== void 0 && visContext.attributes);
  const input$ = (0, _react.useMemo)(() => originalInput$ !== null && originalInput$ !== void 0 ? originalInput$ : new _rxjs.Subject(), [originalInput$]);
  const {
    filters,
    query,
    getTimeRange,
    updateTimeRange,
    relativeTimeRange
  } = requestParams;
  const fetch$ = (0, _use_fetch.useFetch)({
    input$,
    beforeFetch: updateTimeRange
  });
  (0, _use_total_hits.useTotalHits)({
    services,
    dataView,
    request,
    hits,
    chartVisible,
    filters,
    query,
    getTimeRange,
    fetch$,
    onTotalHitsChange,
    isPlainRecord
  });
  const [bucketInterval, setBucketInterval] = (0, _react.useState)();
  const onLoad = (0, _use_stable_callback.useStableCallback)((isLoading, adapters, dataLoadingSubject$) => {
    var _adapters$requests, _lensRequest$response, _adapters$tables, _response$_shards;
    const lensRequest = adapters === null || adapters === void 0 ? void 0 : (_adapters$requests = adapters.requests) === null || _adapters$requests === void 0 ? void 0 : _adapters$requests.getRequests()[0];
    const requestFailed = (lensRequest === null || lensRequest === void 0 ? void 0 : lensRequest.status) === _public.RequestStatus.ERROR;
    const json = lensRequest === null || lensRequest === void 0 ? void 0 : (_lensRequest$response = lensRequest.response) === null || _lensRequest$response === void 0 ? void 0 : _lensRequest$response.json;
    const response = json === null || json === void 0 ? void 0 : json.rawResponse;
    if (requestFailed) {
      onTotalHitsChange === null || onTotalHitsChange === void 0 ? void 0 : onTotalHitsChange(_types.UnifiedHistogramFetchStatus.error, undefined);
      onChartLoad === null || onChartLoad === void 0 ? void 0 : onChartLoad({
        adapters: adapters !== null && adapters !== void 0 ? adapters : {}
      });
      return;
    }
    const adapterTables = adapters === null || adapters === void 0 ? void 0 : (_adapters$tables = adapters.tables) === null || _adapters$tables === void 0 ? void 0 : _adapters$tables.tables;
    const totalHits = computeTotalHits(hasLensSuggestions, adapterTables, isPlainRecord);
    if (response !== null && response !== void 0 && (_response$_shards = response._shards) !== null && _response$_shards !== void 0 && _response$_shards.failed || response !== null && response !== void 0 && response.timed_out) {
      onTotalHitsChange === null || onTotalHitsChange === void 0 ? void 0 : onTotalHitsChange(_types.UnifiedHistogramFetchStatus.error, totalHits);
    } else {
      onTotalHitsChange === null || onTotalHitsChange === void 0 ? void 0 : onTotalHitsChange(isLoading ? _types.UnifiedHistogramFetchStatus.loading : _types.UnifiedHistogramFetchStatus.complete, totalHits !== null && totalHits !== void 0 ? totalHits : hits === null || hits === void 0 ? void 0 : hits.total);
    }
    if (response) {
      const newBucketInterval = (0, _build_bucket_interval.buildBucketInterval)({
        data: services.data,
        dataView,
        timeInterval: chart === null || chart === void 0 ? void 0 : chart.timeInterval,
        timeRange: getTimeRange(),
        response
      });
      setBucketInterval(newBucketInterval);
    }
    onChartLoad === null || onChartLoad === void 0 ? void 0 : onChartLoad({
      adapters: adapters !== null && adapters !== void 0 ? adapters : {},
      dataLoading$: dataLoadingSubject$
    });
  });
  const lensPropsContext = (0, _use_lens_props.useLensProps)({
    request,
    getTimeRange,
    fetch$,
    visContext,
    onLoad
  });
  const {
    chartToolbarCss,
    histogramCss
  } = (0, _use_chart_styles.useChartStyles)(chartVisible);
  const onSuggestionContextEdit = (0, _react.useCallback)(editedSuggestionContext => {
    lensVisService.onSuggestionEdited({
      editedSuggestionContext
    });
  }, [lensVisService]);
  (0, _react.useEffect)(() => {
    // close the flyout for dataview mode
    // or if no chart is visible
    if (!chartVisible && isFlyoutVisible) {
      setIsFlyoutVisible(false);
    }
  }, [chartVisible, isFlyoutVisible]);
  const onEditVisualization = (0, _use_edit_visualization.useEditVisualization)({
    services,
    dataView,
    relativeTimeRange: originalRelativeTimeRange !== null && originalRelativeTimeRange !== void 0 ? originalRelativeTimeRange : relativeTimeRange,
    lensAttributes: visContext === null || visContext === void 0 ? void 0 : visContext.attributes,
    isPlainRecord
  });
  const a11yCommonProps = {
    id: 'unifiedHistogramCollapsablePanel'
  };
  if (Boolean(renderCustomChartToggleActions) && !chartVisible) {
    return /*#__PURE__*/_react.default.createElement("div", (0, _extends2.default)({}, a11yCommonProps, {
      "data-test-subj": "unifiedHistogramChartPanelHidden"
    }));
  }
  const LensSaveModalComponent = services.lens.SaveModalComponent;
  const hasLensSuggestions = Boolean(isPlainRecord && (lensVisServiceCurrentSuggestionContext === null || lensVisServiceCurrentSuggestionContext === void 0 ? void 0 : lensVisServiceCurrentSuggestionContext.type) === _types.UnifiedHistogramSuggestionType.lensSuggestion);
  const canCustomizeVisualization = isPlainRecord && currentSuggestion && [_types.UnifiedHistogramSuggestionType.lensSuggestion, _types.UnifiedHistogramSuggestionType.histogramForESQL].includes(lensVisServiceCurrentSuggestionContext === null || lensVisServiceCurrentSuggestionContext === void 0 ? void 0 : lensVisServiceCurrentSuggestionContext.type);
  const canEditVisualizationOnTheFly = canCustomizeVisualization && chartVisible;
  const canSaveVisualization = canEditVisualizationOnTheFly && ((_services$capabilitie = services.capabilities.dashboard) === null || _services$capabilitie === void 0 ? void 0 : _services$capabilitie.showWriteControls);
  const actions = [];
  if (canEditVisualizationOnTheFly) {
    actions.push({
      label: _i18n.i18n.translate('unifiedHistogram.editVisualizationButton', {
        defaultMessage: 'Edit visualization'
      }),
      iconType: 'pencil',
      isDisabled: isFlyoutVisible,
      'data-test-subj': 'unifiedHistogramEditFlyoutVisualization',
      onClick: () => setIsFlyoutVisible(true)
    });
  } else if (onEditVisualization) {
    actions.push({
      label: _i18n.i18n.translate('unifiedHistogram.editVisualizationButton', {
        defaultMessage: 'Edit visualization'
      }),
      iconType: 'lensApp',
      'data-test-subj': 'unifiedHistogramEditVisualization',
      onClick: onEditVisualization
    });
  }
  if (canSaveVisualization) {
    actions.push({
      label: _i18n.i18n.translate('unifiedHistogram.saveVisualizationButton', {
        defaultMessage: 'Save visualization'
      }),
      iconType: 'save',
      'data-test-subj': 'unifiedHistogramSaveVisualization',
      onClick: () => setIsSaveModalVisible(true)
    });
  }
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, (0, _extends2.default)({}, a11yCommonProps, {
    className: className,
    direction: "column",
    alignItems: "stretch",
    gutterSize: "none",
    responsive: false
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    css: chartToolbarCss
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    direction: "row",
    gutterSize: "s",
    responsive: false,
    alignItems: "center",
    justifyContent: "spaceBetween"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    css: {
      minWidth: 0
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    direction: "row",
    gutterSize: "s",
    responsive: false,
    alignItems: "center"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, renderCustomChartToggleActions ? renderCustomChartToggleActions() : /*#__PURE__*/_react.default.createElement(_sharedUxButtonToolbar.IconButtonGroup, {
    legend: _i18n.i18n.translate('unifiedHistogram.hideChartButtongroupLegend', {
      defaultMessage: 'Chart visibility'
    }),
    buttonSize: "s",
    buttons: [{
      label: chartVisible ? _i18n.i18n.translate('unifiedHistogram.hideChartButton', {
        defaultMessage: 'Hide chart'
      }) : _i18n.i18n.translate('unifiedHistogram.showChartButton', {
        defaultMessage: 'Show chart'
      }),
      iconType: chartVisible ? 'transitionTopOut' : 'transitionTopIn',
      'data-test-subj': 'unifiedHistogramToggleChartButton',
      onClick: toggleHideChart
    }]
  })), chartVisible && !isPlainRecord && !!onTimeIntervalChange && /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    css: {
      minWidth: 0
    }
  }, /*#__PURE__*/_react.default.createElement(_time_interval_selector.TimeIntervalSelector, {
    chart: chart,
    onTimeIntervalChange: onTimeIntervalChange
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    css: {
      minWidth: 0
    }
  }, /*#__PURE__*/_react.default.createElement("div", null, chartVisible && breakdown && /*#__PURE__*/_react.default.createElement(_breakdown_field_selector.BreakdownFieldSelector, {
    dataView: dataView,
    breakdown: breakdown,
    onBreakdownFieldChange: onBreakdownFieldChange,
    esqlColumns: isPlainRecord ? columns : undefined
  }))))), chartVisible && actions.length > 0 && /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_sharedUxButtonToolbar.IconButtonGroup, {
    legend: _i18n.i18n.translate('unifiedHistogram.chartActionsGroupLegend', {
      defaultMessage: 'Chart actions'
    }),
    buttonSize: "s",
    buttons: actions
  })))), chartVisible && /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement("section", {
    ref: element => chartRef.current.element = element,
    tabIndex: -1,
    "aria-label": _i18n.i18n.translate('unifiedHistogram.histogramOfFoundDocumentsAriaLabel', {
      defaultMessage: 'Histogram of found documents'
    }),
    css: histogramCss,
    "data-test-subj": "unifiedHistogramRendered"
  }, isChartLoading &&
  /*#__PURE__*/
  /*
    There are 2 different loaders which can appear above the chart. One is from the embeddable and one is from the UnifiedHistogram.
    The idea is to show UnifiedHistogram loader until we get a new query params which would trigger the embeddable loader.
    Updates to the time range can come earlier than the query updates which we delay on purpose for text based mode,
    this is why it might get both loaders. We should find a way to resolve that better.
  */
  _react.default.createElement(_eui.EuiDelayRender, {
    delay: 500,
    "data-test-subj": "unifiedHistogramProgressBar"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiProgress, {
    size: "xs",
    color: "accent",
    position: "absolute"
  })), lensPropsContext && /*#__PURE__*/_react.default.createElement(HistogramMemoized, (0, _extends2.default)({
    abortController: abortController,
    services: services,
    dataView: dataView,
    chart: chart,
    bucketInterval: bucketInterval,
    getTimeRange: getTimeRange,
    visContext: visContext,
    isPlainRecord: isPlainRecord,
    disableTriggers: disableTriggers,
    disabledActions: disabledActions,
    onFilter: onFilter,
    onBrushEnd: onBrushEnd,
    withDefaultActions: withDefaultActions
  }, lensPropsContext))), appendHistogram), canSaveVisualization && isSaveModalVisible && visContext.attributes && /*#__PURE__*/_react.default.createElement(LensSaveModalComponent, {
    initialInput: (0, _lens_vis_from_table.removeTablesFromLensAttributes)(visContext.attributes),
    onSave: () => {},
    onClose: () => setIsSaveModalVisible(false),
    isSaveable: false
  }), isFlyoutVisible && !!visContext && !!lensVisServiceCurrentSuggestionContext && /*#__PURE__*/_react.default.createElement(_chart_config_panel.ChartConfigPanel, {
    services: services,
    visContext: visContext,
    lensAdapters: lensAdapters,
    dataLoading$: dataLoading$,
    isFlyoutVisible: isFlyoutVisible,
    setIsFlyoutVisible: setIsFlyoutVisible,
    isPlainRecord: isPlainRecord,
    query: query,
    currentSuggestionContext: lensVisServiceCurrentSuggestionContext,
    onSuggestionContextEdit: onSuggestionContextEdit
  }));
}
const computeTotalHits = (hasLensSuggestions, adapterTables, isPlainRecord) => {
  if (isPlainRecord && hasLensSuggestions) {
    var _Object$values, _Object$values$, _Object$values$$rows;
    return (_Object$values = Object.values(adapterTables !== null && adapterTables !== void 0 ? adapterTables : {})) === null || _Object$values === void 0 ? void 0 : (_Object$values$ = _Object$values[0]) === null || _Object$values$ === void 0 ? void 0 : (_Object$values$$rows = _Object$values$.rows) === null || _Object$values$$rows === void 0 ? void 0 : _Object$values$$rows.length;
  } else if (isPlainRecord && !hasLensSuggestions) {
    var _Object$values2, _Object$values2$;
    // ES|QL histogram case
    const rows = (_Object$values2 = Object.values(adapterTables !== null && adapterTables !== void 0 ? adapterTables : {})) === null || _Object$values2 === void 0 ? void 0 : (_Object$values2$ = _Object$values2[0]) === null || _Object$values2$ === void 0 ? void 0 : _Object$values2$.rows;
    if (!rows) {
      return undefined;
    }
    let rowsCount = 0;
    rows.forEach(r => {
      rowsCount += r.results;
    });
    return rowsCount;
  } else {
    var _adapterTables$unifie, _adapterTables$unifie2, _adapterTables$unifie3;
    return adapterTables === null || adapterTables === void 0 ? void 0 : (_adapterTables$unifie = adapterTables.unifiedHistogram) === null || _adapterTables$unifie === void 0 ? void 0 : (_adapterTables$unifie2 = _adapterTables$unifie.meta) === null || _adapterTables$unifie2 === void 0 ? void 0 : (_adapterTables$unifie3 = _adapterTables$unifie2.statistics) === null || _adapterTables$unifie3 === void 0 ? void 0 : _adapterTables$unifie3.totalCount;
  }
};