"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useUIFieldActions = exports.useFieldActionsContext = exports.FieldActionsProvider = void 0;
var _react = require("react");
var _constate = _interopRequireDefault(require("constate"));
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

/**
 * Higher level hook that wraps the logic for the requires actions on a field.
 */
const useFieldActions = ({
  columns,
  filter,
  onAddColumn,
  onRemoveColumn
}) => {
  return (0, _react.useMemo)(() => ({
    addColumn: onAddColumn,
    addFilterExist: ({
      field
    }) => filter && filter('_exists_', field, '+'),
    addFilterIn: ({
      field,
      value,
      mapping
    }) => filter && filter(mapping !== null && mapping !== void 0 ? mapping : field, value, '+'),
    addFilterOut: ({
      field,
      value,
      mapping
    }) => filter && filter(mapping !== null && mapping !== void 0 ? mapping : field, value, '-'),
    copyToClipboard: _eui.copyToClipboard,
    removeColumn: onRemoveColumn,
    toggleFieldColumn: ({
      field
    }) => {
      if (!columns) return;
      const isFieldInTable = columns.includes(field);
      if (isFieldInTable && onRemoveColumn) {
        onRemoveColumn(field);
      } else if (!isFieldInTable && onAddColumn) {
        onAddColumn(field);
      }
    }
  }), [columns, filter, onAddColumn, onRemoveColumn]);
};
const [FieldActionsProvider, useFieldActionsContext] = (0, _constate.default)(useFieldActions);

/**
 * This is a preset of the UI elements and related actions that can be used to build an action bar anywhere in a DocView
 */
exports.useFieldActionsContext = useFieldActionsContext;
exports.FieldActionsProvider = FieldActionsProvider;
const useUIFieldActions = ({
  field,
  value,
  mapping,
  formattedValue
}) => {
  const actions = useFieldActionsContext();
  return (0, _react.useMemo)(() => [{
    id: 'addFilterInAction',
    iconType: 'plusInCircle',
    label: filterForValueLabel,
    onClick: () => actions.addFilterIn({
      field,
      value,
      mapping
    })
  }, {
    id: 'addFilterOutremoveFromFilterAction',
    iconType: 'minusInCircle',
    label: filterOutValueLabel,
    onClick: () => actions.addFilterOut({
      field,
      value,
      mapping
    })
  }, {
    id: 'addFilterExistAction',
    iconType: 'filter',
    label: filterForFieldPresentLabel,
    onClick: () => actions.addFilterExist({
      field
    })
  }, {
    id: 'toggleFieldColumnAction',
    iconType: 'listAdd',
    label: toggleColumnLabel,
    onClick: () => actions.toggleFieldColumn({
      field
    })
  }, {
    id: 'copyToClipboardAction',
    iconType: 'copyClipboard',
    label: copyToClipboardLabel,
    onClick: () => actions.copyToClipboard(formattedValue !== null && formattedValue !== void 0 ? formattedValue : value)
  }], [actions, field, mapping, formattedValue, value]);
};
exports.useUIFieldActions = useUIFieldActions;
const filterForValueLabel = _i18n.i18n.translate('unifiedDocViewer.fieldActions.filterForValue', {
  defaultMessage: 'Filter for value'
});
const filterOutValueLabel = _i18n.i18n.translate('unifiedDocViewer.fieldActions.filterOutValue', {
  defaultMessage: 'Filter out value'
});
const filterForFieldPresentLabel = _i18n.i18n.translate('unifiedDocViewer.fieldActions.filterForFieldPresent', {
  defaultMessage: 'Filter for field present'
});
const toggleColumnLabel = _i18n.i18n.translate('unifiedDocViewer.fieldActions.toggleColumn', {
  defaultMessage: 'Toggle column in table'
});
const copyToClipboardLabel = _i18n.i18n.translate('unifiedDocViewer.fieldActions.copyToClipboard', {
  defaultMessage: 'Copy to clipboard'
});