"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.SpanFlyout = void 0;
var _eui = require("@elastic/eui");
var _objectUtils = require("@kbn/object-utils");
var _react = _interopRequireWildcard(require("react"));
var _i18n = require("@kbn/i18n");
var _use_span = require("../hooks/use_span");
var _span_flyout_body = require("./span_flyout_body");
var _is_span = require("../helpers/is_span");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

const flyoutId = 'spanDetailFlyout';
const SpanFlyout = ({
  tracesIndexPattern,
  spanId,
  dataView,
  onCloseFlyout
}) => {
  const {
    span,
    docId,
    loading
  } = (0, _use_span.useSpan)({
    indexPattern: tracesIndexPattern,
    spanId
  });
  const {
    euiTheme
  } = (0, _eui.useEuiTheme)();
  const documentAsHit = (0, _react.useMemo)(() => {
    if (!span || !docId) return null;
    return {
      id: docId,
      raw: {
        _index: span._index,
        _id: docId,
        _source: span
      },
      flattened: (0, _objectUtils.flattenObject)(span)
    };
  }, [docId, span]);
  const isSpan = (0, _is_span.isSpanHit)(documentAsHit);
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFlyout, {
    includeFixedHeadersInFocusTrap: false,
    ownFocus: false,
    css: {
      zIndex: euiTheme.levels.mask + 1,
      top: '0'
    },
    onClose: onCloseFlyout,
    "aria-labelledby": flyoutId
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlyoutHeader, {
    hasBorder: true
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiSkeletonTitle, {
    isLoading: loading
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
    size: "m"
  }, /*#__PURE__*/_react.default.createElement("h2", {
    id: flyoutId
  }, _i18n.i18n.translate('unifiedDocViewer.observability.traces.fullScreenWaterfall.spanFlyout.title', {
    defaultMessage: '{docType} document',
    values: {
      docType: isSpan ? _i18n.i18n.translate('unifiedDocViewer.observability.traces.fullScreenWaterfall.spanFlyout.title.span', {
        defaultMessage: 'Span'
      }) : _i18n.i18n.translate('unifiedDocViewer.observability.traces.fullScreenWaterfall.spanFlyout.title.transction', {
        defaultMessage: 'Transaction'
      })
    }
  }))))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlyoutBody, null, /*#__PURE__*/_react.default.createElement(_span_flyout_body.SpanFlyoutBody, {
    tracesIndexPattern: tracesIndexPattern,
    hit: documentAsHit,
    dataView: dataView,
    loading: loading,
    onCloseFlyout: onCloseFlyout
  })));
};
exports.SpanFlyout = SpanFlyout;