"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.FullScreenWaterfall = void 0;
var _react = _interopRequireWildcard(require("react"));
var _public = require("@kbn/embeddable-plugin/public");
var _eui = require("@elastic/eui");
var _discoverUtils = require("@kbn/discover-utils");
var _i18n = require("@kbn/i18n");
var _plugin = require("../../../../../plugin");
var _span_flyout = require("./span_flyout");
var _use_root_transaction = require("../../doc_viewer_transaction_overview/hooks/use_root_transaction");
var _use_data_sources = require("../../hooks/use_data_sources");
var _exit_full_screen_button = require("./exit_full_screen_button");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

const FullScreenWaterfall = ({
  traceId,
  rangeFrom,
  rangeTo,
  dataView,
  tracesIndexPattern,
  onExitFullScreen
}) => {
  const {
    transaction
  } = (0, _use_root_transaction.useRootTransactionContext)();
  const [spanId, setSpanId] = (0, _react.useState)(null);
  const [isFlyoutVisible, setIsFlyoutVisible] = (0, _react.useState)(false);
  const overlayMaskRef = (0, _react.useRef)(null);
  const {
    euiTheme
  } = (0, _eui.useEuiTheme)();
  const {
    share: {
      url: {
        locators
      }
    },
    data: {
      query: {
        timefilter: {
          timefilter
        }
      }
    }
  } = (0, _plugin.getUnifiedDocViewerServices)();
  const {
    indexes
  } = (0, _use_data_sources.useDataSourcesContext)();
  const discoverLocator = (0, _react.useMemo)(() => locators.get('DISCOVER_APP_LOCATOR'), [locators]);
  const generateRelatedErrorsDiscoverUrl = (0, _react.useCallback)(docId => {
    if (!discoverLocator) {
      return null;
    }
    const url = discoverLocator.getRedirectUrl({
      timeRange: timefilter.getAbsoluteTime(),
      filters: [],
      query: {
        language: 'kuery',
        esql: `FROM ${indexes.apm.errors},${indexes.logs} | WHERE QSTR("trace.id:${traceId} AND span.id:${docId}")`
      }
    });
    return url;
  }, [discoverLocator, timefilter, indexes.apm.errors, indexes.logs, traceId]);
  const getParentApi = (0, _react.useCallback)(() => ({
    getSerializedStateForChild: () => ({
      rawState: {
        traceId,
        rangeFrom,
        rangeTo,
        serviceName: transaction === null || transaction === void 0 ? void 0 : transaction[_discoverUtils.SERVICE_NAME_FIELD],
        entryTransactionId: (transaction === null || transaction === void 0 ? void 0 : transaction[_discoverUtils.TRANSACTION_ID_FIELD]) || (transaction === null || transaction === void 0 ? void 0 : transaction[_discoverUtils.SPAN_ID_FIELD]),
        scrollElement: overlayMaskRef.current,
        getRelatedErrorsHref: generateRelatedErrorsDiscoverUrl,
        onNodeClick: nodeSpanId => {
          setSpanId(nodeSpanId);
          setIsFlyoutVisible(true);
        }
      }
    })
  }), [traceId, rangeFrom, rangeTo, transaction, generateRelatedErrorsDiscoverUrl]);
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiOverlayMask, {
    maskRef: overlayMaskRef,
    css: {
      paddingBlockEnd: '0 !important',
      overflowY: 'scroll',
      backgroundColor: `${euiTheme.colors.backgroundBasePlain} !important`
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFocusTrap, {
    css: {
      height: '100%',
      width: '100%'
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiPanel, {
    hasShadow: false,
    css: {
      minHeight: '100%',
      width: '100%'
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    alignItems: "center"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: 1
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
    size: "l"
  }, /*#__PURE__*/_react.default.createElement("h2", null, _i18n.i18n.translate('unifiedDocViewer.observability.traces.fullScreenWaterfall.title', {
    defaultMessage: 'Trace timeline'
  })))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: 1,
    css: {
      alignItems: 'end'
    }
  }, /*#__PURE__*/_react.default.createElement(_exit_full_screen_button.ExitFullScreenButton, {
    onExitFullScreen: onExitFullScreen,
    dataTestSubj: "unifiedDocViewerObservabilityTracesFullScreenWaterfallExitFullScreenButton",
    ariaLabel: _i18n.i18n.translate('unifiedDocViewer.observability.traces.fullScreenWaterfall.exitFullScreen.button', {
      defaultMessage: 'Exit full screen waterfall'
    })
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m"
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_public.EmbeddableRenderer, {
    type: "APM_TRACE_WATERFALL_EMBEDDABLE",
    getParentApi: getParentApi,
    hidePanelChrome: true
  })))))), isFlyoutVisible && spanId && /*#__PURE__*/_react.default.createElement(_eui.EuiFocusTrap, null, /*#__PURE__*/_react.default.createElement(_span_flyout.SpanFlyout, {
    tracesIndexPattern: tracesIndexPattern,
    spanId: spanId,
    dataView: dataView,
    onCloseFlyout: () => {
      setIsFlyoutVisible(false);
    }
  })));
};
exports.FullScreenWaterfall = FullScreenWaterfall;