"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useSpan = void 0;
var _i18n = require("@kbn/i18n");
var _rxjs = require("rxjs");
var _discoverUtils = require("@kbn/discover-utils");
var _react = require("react");
var _plugin = require("../../../../../../../plugin");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

async function getSpanData({
  spanId,
  indexPattern,
  data,
  signal
}) {
  return (0, _rxjs.lastValueFrom)(data.search.search({
    params: {
      index: indexPattern,
      size: 1,
      body: {
        timeout: '20s',
        fields: [{
          field: '*',
          include_unmapped: true
        }],
        query: {
          match: {
            [_discoverUtils.SPAN_ID_FIELD]: spanId
          }
        }
      }
    }
  }, {
    abortSignal: signal
  }));
}
const useSpan = ({
  spanId,
  indexPattern
}) => {
  const {
    data,
    core
  } = (0, _plugin.getUnifiedDocViewerServices)();
  const [span, setSpan] = (0, _react.useState)(null);
  const [loading, setLoading] = (0, _react.useState)(true);
  const [docId, setDocId] = (0, _react.useState)(null);
  (0, _react.useEffect)(() => {
    if (!spanId) {
      setSpan(null);
      setLoading(false);
      return;
    }
    const controller = new AbortController();
    const {
      signal
    } = controller;
    const fetchData = async () => {
      try {
        var _result$rawResponse$h, _result$rawResponse$h2, _result$rawResponse$h3, _result$rawResponse$h4;
        setLoading(true);
        const result = await getSpanData({
          spanId,
          indexPattern,
          data,
          signal
        });
        setSpan((_result$rawResponse$h = (_result$rawResponse$h2 = result.rawResponse.hits.hits[0]) === null || _result$rawResponse$h2 === void 0 ? void 0 : _result$rawResponse$h2.fields) !== null && _result$rawResponse$h !== void 0 ? _result$rawResponse$h : null);
        setDocId((_result$rawResponse$h3 = (_result$rawResponse$h4 = result.rawResponse.hits.hits[0]) === null || _result$rawResponse$h4 === void 0 ? void 0 : _result$rawResponse$h4._id) !== null && _result$rawResponse$h3 !== void 0 ? _result$rawResponse$h3 : null);
      } catch (err) {
        if (!signal.aborted) {
          const error = err;
          core.notifications.toasts.addDanger({
            title: _i18n.i18n.translate('unifiedDocViewer.fullScreenWaterfall.useSpan.error', {
              defaultMessage: 'An error occurred while fetching the span'
            }),
            text: error.message
          });
          setSpan(null);
        }
      } finally {
        setLoading(false);
      }
    };
    fetchData();
    return function onUnmount() {
      controller.abort();
    };
  }, [core.notifications.toasts, data, indexPattern, spanId]);
  return {
    loading,
    span,
    docId
  };
};
exports.useSpan = useSpan;