"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.TableCell = void 0;
var _react = _interopRequireWildcard(require("react"));
var _unifiedDocViewer = require("@kbn/unified-doc-viewer");
var _fieldUtils = require("@kbn/field-utils");
var _table_cell_value = require("./table_cell_value");
var _table_filters = require("./table_filters");
var _plugin = require("../../plugin");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

const TableCell = exports.TableCell = /*#__PURE__*/_react.default.memo(({
  searchTerm,
  rows,
  rowIndex,
  columnId,
  isDetails,
  onFindSearchTermMatch
}) => {
  const {
    fieldsMetadata
  } = (0, _plugin.getUnifiedDocViewerServices)();
  const row = rows[rowIndex];
  const searchTermMatch = (0, _react.useMemo)(() => {
    if (row && onFindSearchTermMatch && searchTerm !== null && searchTerm !== void 0 && searchTerm.trim()) {
      return onFindSearchTermMatch(row, searchTerm);
    }
    return null;
  }, [onFindSearchTermMatch, row, searchTerm]);
  const nameHighlight = (0, _react.useMemo)(() => {
    var _row$dataViewField;
    return row && searchTermMatch && [_table_filters.TermMatch.name, _table_filters.TermMatch.both].includes(searchTermMatch) ? (0, _fieldUtils.getFieldSearchMatchingHighlight)(((_row$dataViewField = row.dataViewField) === null || _row$dataViewField === void 0 ? void 0 : _row$dataViewField.displayName) || row.name, searchTerm) : undefined;
  }, [searchTerm, searchTermMatch, row]);
  if (!row) {
    return null;
  }
  const {
    flattenedValue,
    name,
    displayNameOverride,
    dataViewField,
    ignoredReason,
    fieldType
  } = row;
  if (columnId === 'name') {
    return /*#__PURE__*/_react.default.createElement("div", null, /*#__PURE__*/_react.default.createElement(_unifiedDocViewer.FieldName, {
      fieldName: name,
      displayNameOverride: displayNameOverride,
      fieldType: fieldType,
      fieldMapping: dataViewField,
      scripted: dataViewField === null || dataViewField === void 0 ? void 0 : dataViewField.scripted,
      highlight: nameHighlight
    }), isDetails && !!dataViewField ? /*#__PURE__*/_react.default.createElement("div", null, /*#__PURE__*/_react.default.createElement(_fieldUtils.FieldDescription, {
      fieldsMetadataService: fieldsMetadata,
      field: dataViewField,
      truncate: false
    })) : null);
  }
  if (columnId === 'value') {
    var _row$formattedAsHtml;
    return /*#__PURE__*/_react.default.createElement(_table_cell_value.TableFieldValue, {
      field: name,
      formattedValue: (_row$formattedAsHtml = row.formattedAsHtml) !== null && _row$formattedAsHtml !== void 0 ? _row$formattedAsHtml : '',
      rawValue: flattenedValue,
      ignoreReason: ignoredReason,
      isDetails: isDetails,
      isHighlighted: Boolean(searchTermMatch && [_table_filters.TermMatch.value, _table_filters.TermMatch.both].includes(searchTermMatch))
    });
  }
  return null;
});