"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.TableActions = void 0;
var _react = _interopRequireDefault(require("react"));
var _table_row_btn_filter_remove = require("./table_row_btn_filter_remove");
var _table_row_btn_filter_exists = require("./table_row_btn_filter_exists");
var _table_row_btn_toggle_column = require("./table_row_btn_toggle_column");
var _table_row_btn_filter_add = require("./table_row_btn_filter_add");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

const TableActions = ({
  isActive,
  field,
  fieldMapping,
  flattenedField,
  onToggleColumn,
  onFilter,
  ignoredValue
}) => {
  return /*#__PURE__*/_react.default.createElement("div", {
    className: "kbnDocViewer__buttons"
  }, onFilter && /*#__PURE__*/_react.default.createElement(_table_row_btn_filter_add.DocViewTableRowBtnFilterAdd, {
    disabled: !fieldMapping || !fieldMapping.filterable || ignoredValue,
    onClick: () => onFilter(fieldMapping, flattenedField, '+')
  }), onFilter && /*#__PURE__*/_react.default.createElement(_table_row_btn_filter_remove.DocViewTableRowBtnFilterRemove, {
    disabled: !fieldMapping || !fieldMapping.filterable || ignoredValue,
    onClick: () => onFilter(fieldMapping, flattenedField, '-')
  }), onToggleColumn && /*#__PURE__*/_react.default.createElement(_table_row_btn_toggle_column.DocViewTableRowBtnToggleColumn, {
    active: isActive,
    fieldname: field,
    onClick: () => onToggleColumn(field)
  }), onFilter && /*#__PURE__*/_react.default.createElement(_table_row_btn_filter_exists.DocViewTableRowBtnFilterExists, {
    disabled: !fieldMapping || !fieldMapping.filterable,
    onClick: () => onFilter('_exists_', field, '+'),
    scripted: fieldMapping && fieldMapping.scripted
  }));
};
exports.TableActions = TableActions;