"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.HoverActionPopover = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _reactHooks = require("@kbn/react-hooks");
var _use_field_actions = require("../../../hooks/use_field_actions");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

const MAX_CHAR_LENGTH = 500;
const readMore = _i18n.i18n.translate('unifiedDocViewer.observability.traces.details.readMore', {
  defaultMessage: 'Read more'
});
const readLess = _i18n.i18n.translate('unifiedDocViewer.observability.traces.details.readLess', {
  defaultMessage: 'Read less'
});
const HoverActionPopover = ({
  children,
  title,
  field,
  value,
  formattedValue,
  rawFieldValue,
  anchorPosition = 'upCenter',
  display = 'inline-block',
  truncate
}) => {
  const [isPopoverOpen, setIsPopoverOpen] = (0, _react.useState)(false);
  const leaveTimer = (0, _react.useRef)(null);
  const cleanValueForActions = rawFieldValue !== null && rawFieldValue !== void 0 ? rawFieldValue : value;
  const uiFieldActions = (0, _use_field_actions.useUIFieldActions)({
    field,
    value: cleanValueForActions,
    formattedValue
  });

  // The timeout hack is required because we are using a Popover which ideally should be used with a mouseclick,
  // but we are using it as a Tooltip. Which means we now need to manually handle the open and close
  // state using the mouse hover events. This cause the popover to close even before the user could
  // navigate actions inside it. Hence, to prevent this, we need this hack
  const onMouseEnter = () => {
    if (leaveTimer.current) {
      clearTimeout(leaveTimer.current);
    }
    setIsPopoverOpen(true);
  };
  const getTitleText = () => {
    if (Array.isArray(title)) {
      return title.join(' ');
    } else if (typeof title === 'string') {
      return title;
    }
    return title;
  };
  const onMouseLeave = () => {
    leaveTimer.current = setTimeout(() => setIsPopoverOpen(false), 100);
  };
  const titleText = getTitleText();
  const {
    displayText,
    isExpanded,
    toggleExpanded,
    shouldTruncate
  } = (0, _reactHooks.useTruncateText)(titleText, MAX_CHAR_LENGTH);
  const displayTitle = truncate ? displayText : titleText;
  return /*#__PURE__*/_react.default.createElement("span", {
    onMouseEnter: onMouseEnter,
    onMouseLeave: onMouseLeave
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiPopover, {
    button: children,
    isOpen: isPopoverOpen,
    anchorPosition: shouldTruncate ? 'leftCenter' : anchorPosition,
    closePopover: closePopoverPlaceholder,
    panelPaddingSize: "s",
    panelStyle: {
      minWidth: '24px'
    },
    display: display
  }, title && /*#__PURE__*/_react.default.createElement(_eui.EuiPopoverTitle, {
    className: "eui-textBreakWord",
    css: {
      maxWidth: isExpanded ? '350px' : '300px',
      display: 'flex',
      flexDirection: 'column'
    }
  }, displayTitle, shouldTruncate && truncate && /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
    onClick: toggleExpanded
  }, isExpanded ? readLess : readMore)), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    wrap: true,
    gutterSize: "none",
    alignItems: "center",
    justifyContent: "spaceBetween"
  }, uiFieldActions.map(action => /*#__PURE__*/_react.default.createElement(_eui.EuiToolTip, {
    content: action.label,
    key: action.id
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonIcon, {
    "data-test-subj": "unifiedDocViewLogsOverviewHoverActionPopoverButton",
    size: "xs",
    iconType: action.iconType,
    "aria-label": action.label,
    onClick: action.onClick
  }))))));
};
exports.HoverActionPopover = HoverActionPopover;
const closePopoverPlaceholder = () => {};