"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.AdvancedUiActionsPublicPlugin = void 0;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _rxjs = require("rxjs");
var _public = require("@kbn/kibana-utils-plugin/public");
var _services = require("./services");
var _drilldowns = require("./drilldowns");
var _dynamic_action_enhancement = require("./dynamic_actions/dynamic_action_enhancement");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

class AdvancedUiActionsPublicPlugin {
  getLicenseInfo() {
    if (!this.licenseInfo.getValue()) {
      throw new Error('AdvancedUiActionsPublicPlugin: License is not ready! License becomes available only after setup.');
    }
    return this.licenseInfo.getValue();
  }
  constructor(initializerContext) {
    (0, _defineProperty2.default)(this, "licenseInfo", new _rxjs.BehaviorSubject(undefined));
    (0, _defineProperty2.default)(this, "enhancements", void 0);
    (0, _defineProperty2.default)(this, "subs", []);
  }
  setup(core, {
    embeddable,
    uiActions,
    licensing
  }) {
    const startServices = (0, _public.createStartServicesGetter)(core.getStartServices);
    this.enhancements = new _services.UiActionsServiceEnhancements({
      getLicense: () => this.getLicenseInfo(),
      featureUsageSetup: licensing === null || licensing === void 0 ? void 0 : licensing.featureUsage,
      getFeatureUsageStart: () => {
        var _startServices$plugin;
        return (_startServices$plugin = startServices().plugins.licensing) === null || _startServices$plugin === void 0 ? void 0 : _startServices$plugin.featureUsage;
      }
    });
    embeddable.registerEnhancement((0, _dynamic_action_enhancement.dynamicActionEnhancement)(this.enhancements));
    return {
      ...uiActions,
      ...this.enhancements
    };
  }
  start(core, {
    uiActions,
    licensing
  }) {
    var _window;
    if (licensing) this.subs.push(licensing.license$.subscribe(this.licenseInfo));
    return {
      ...uiActions,
      ...this.enhancements,
      DrilldownManager: (0, _drilldowns.createPublicDrilldownManager)({
        actionFactories: this.enhancements.getActionFactories(),
        getTrigger: triggerId => uiActions.getTrigger(triggerId),
        storage: new _public.Storage((_window = window) === null || _window === void 0 ? void 0 : _window.localStorage),
        toastService: core.notifications.toasts,
        docsLink: core.docLinks.links.dashboard.drilldowns,
        triggerPickerDocsLink: core.docLinks.links.dashboard.drilldownsTriggerPicker
      })
    };
  }
  stop() {
    this.subs.forEach(s => s.unsubscribe());
  }
}
exports.AdvancedUiActionsPublicPlugin = AdvancedUiActionsPublicPlugin;