"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.TriggerPickerItem = void 0;
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

const txtUnknown = _i18n.i18n.translate('uiActionsEnhanced.components.TriggerPickerItem.unknown', {
  defaultMessage: 'Unknown'
});
const TriggerPickerItem = ({
  id,
  title = txtUnknown,
  description,
  checked,
  disabled,
  onSelect
}) => {
  const descriptionFragment = !!description && /*#__PURE__*/_react.default.createElement("div", null, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    size: 's'
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiTextColor, {
    color: 'subdued'
  }, description)));
  const label = /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
    size: 'xxs'
  }, /*#__PURE__*/_react.default.createElement("span", null, title)), descriptionFragment);
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiCheckableCard, {
    id: id,
    label: label,
    name: id,
    value: id,
    checked: checked,
    disabled: disabled,
    onChange: () => onSelect(id),
    "data-test-subj": `triggerPicker-${id}`
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: 's'
  }));
};
exports.TriggerPickerItem = TriggerPickerItem;