"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.txtTriggerColumnTitle = exports.txtSourceColumnTitle = exports.txtSingleItemCopyActionLabel = exports.txtSelectableMessage = exports.txtNameColumnTitle = exports.txtCopyButtonLabel = exports.txtActionColumnTitle = void 0;
var _i18n = require("@kbn/i18n");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

const txtSelectableMessage = exports.txtSelectableMessage = _i18n.i18n.translate('uiActionsEnhanced.components.DrilldownTemplateTable.selectableMessage', {
  defaultMessage: 'Select this template'
});
const txtNameColumnTitle = exports.txtNameColumnTitle = _i18n.i18n.translate('uiActionsEnhanced.components.DrilldownTemplateTable.nameColumnTitle', {
  defaultMessage: 'Name',
  description: 'Title of the first column in drilldown template cloning table.'
});
const txtSourceColumnTitle = exports.txtSourceColumnTitle = _i18n.i18n.translate('uiActionsEnhanced.components.DrilldownTemplateTable.sourceColumnTitle', {
  defaultMessage: 'Panel',
  description: 'Column title which describes from where the drilldown is cloned.'
});
const txtActionColumnTitle = exports.txtActionColumnTitle = _i18n.i18n.translate('uiActionsEnhanced.components.DrilldownTemplateTable.actionColumnTitle', {
  defaultMessage: 'Action'
});
const txtTriggerColumnTitle = exports.txtTriggerColumnTitle = _i18n.i18n.translate('uiActionsEnhanced.components.DrilldownTemplateTable.triggerColumnTitle', {
  defaultMessage: 'Trigger'
});
const txtSingleItemCopyActionLabel = exports.txtSingleItemCopyActionLabel = _i18n.i18n.translate('uiActionsEnhanced.components.DrilldownTemplateTable.singleItemCopyAction', {
  defaultMessage: 'Copy',
  description: '"Copy" action button label in drilldown template cloning table last column.'
});
const txtCopyButtonLabel = count => _i18n.i18n.translate('uiActionsEnhanced.components.DrilldownTemplateTable.copyButtonLabel', {
  defaultMessage: 'Copy ({count})',
  description: 'Label of drilldown template table bottom copy button.',
  values: {
    count
  }
});
exports.txtCopyButtonLabel = txtCopyButtonLabel;