"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getTimeOptions = exports.getTimeFieldOptions = void 0;
var _get_time_unit_label = require("./get_time_unit_label");
var _constants = require("../../application/constants");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const getTimeOptions = unitSize => Object.entries(_constants.TIME_UNITS).map(([_key, value]) => {
  return {
    text: (0, _get_time_unit_label.getTimeUnitLabel)(value, unitSize.toString()),
    value
  };
});
exports.getTimeOptions = getTimeOptions;
const getTimeFieldOptions = fields => {
  const options = [];
  fields.forEach(field => {
    if (field.type === 'date' || field.type === 'date_nanos') {
      options.push({
        text: field.name,
        value: field.name
      });
    }
  });
  return options;
};
exports.getTimeFieldOptions = getTimeFieldOptions;