"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getDataViewsService = void 0;
exports.getESIndexFields = getESIndexFields;
exports.getMatchingIndices = getMatchingIndices;
exports.setDataViewsService = exports.loadIndexPatterns = void 0;
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const DATA_API_ROOT = '/internal/triggers_actions_ui/data';
const formatPattern = pattern => {
  let formattedPattern = pattern;
  if (!formattedPattern.startsWith('*')) {
    formattedPattern = `*${formattedPattern}`;
  }
  if (!formattedPattern.endsWith('*')) {
    formattedPattern = `${formattedPattern}*`;
  }
  return formattedPattern;
};
async function getMatchingIndices({
  pattern,
  http
}) {
  try {
    // prepend and append index search requests with `*` to match the given text in middle of index names
    const formattedPattern = formatPattern(pattern);
    const {
      indices
    } = await http.post(`${DATA_API_ROOT}/_indices`, {
      body: JSON.stringify({
        pattern: formattedPattern
      })
    });
    return indices;
  } catch (e) {
    return [];
  }
}
async function getESIndexFields({
  indexes,
  http
}) {
  const {
    fields
  } = await http.post(`${DATA_API_ROOT}/_fields`, {
    body: JSON.stringify({
      indexPatterns: indexes
    })
  });
  return fields;
}
let dataViewsService;
const setDataViewsService = aDataViewsService => {
  dataViewsService = aDataViewsService;
};
exports.setDataViewsService = setDataViewsService;
const getDataViewsService = () => {
  return dataViewsService;
};
exports.getDataViewsService = getDataViewsService;
const loadIndexPatterns = async pattern => {
  const formattedPattern = formatPattern(pattern);
  const perPage = 1000;
  try {
    const dataViews = await getDataViewsService().find(formattedPattern, perPage);
    return dataViews.map(dataView => dataView.title);
  } catch (e) {
    return [];
  }
};
exports.loadIndexPatterns = loadIndexPatterns;