"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.RulesListErrorBanner = void 0;
var _react = _interopRequireDefault(require("react"));
var _i18nReact = require("@kbn/i18n-react");
var _eui = require("@elastic/eui");
var _get_experimental_features = require("../../../../common/get_experimental_features");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const RulesListErrorBanner = props => {
  const {
    rulesLastRunOutcomes,
    setRuleExecutionStatusesFilter,
    setRuleLastRunOutcomesFilter
  } = props;
  const onClick = () => {
    const isRuleUsingExecutionStatus = (0, _get_experimental_features.getIsExperimentalFeatureEnabled)('ruleUseExecutionStatus');
    if (isRuleUsingExecutionStatus) {
      setRuleExecutionStatusesFilter(['error']);
    } else {
      setRuleLastRunOutcomesFilter(['failed']);
    }
  };
  if (rulesLastRunOutcomes.failed === 0) {
    return null;
  }
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiCallOut, {
    color: "danger",
    size: "s",
    "data-test-subj": "rulesErrorBanner"
  }, /*#__PURE__*/_react.default.createElement("p", null, /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
    color: "danger",
    type: "warning"
  }), "\xA0", /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.triggersActionsUI.sections.rulesList.attentionBannerTitle",
    defaultMessage: "Error found in {totalStatusesError, plural, one {# rule} other {# rules}}.",
    values: {
      totalStatusesError: rulesLastRunOutcomes.failed
    }
  }), "\xA0", /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
    color: "primary",
    onClick: onClick
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.triggersActionsUI.sections.rulesList.viewBannerButtonLabel",
    defaultMessage: "Show {totalStatusesError, plural, one {rule} other {rules}} with error",
    values: {
      totalStatusesError: rulesLastRunOutcomes.failed
    }
  })))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "s"
  }));
};
exports.RulesListErrorBanner = RulesListErrorBanner;