"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.i18nNthWeekdayShort = exports.i18nNthWeekday = exports.i18nFreqSummary = exports.i18nEndControlOptions = void 0;
var _i18n = require("@kbn/i18n");
var _types = require("../../../../../../types");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const i18nNthWeekday = dayOfWeek => [_i18n.i18n.translate('xpack.triggersActionsUI.ruleSnoozeScheduler.recurLast', {
  defaultMessage: 'Monthly on the last {dayOfWeek}',
  values: {
    dayOfWeek
  }
}), _i18n.i18n.translate('xpack.triggersActionsUI.ruleSnoozeScheduler.recurFirst', {
  defaultMessage: 'Monthly on the first {dayOfWeek}',
  values: {
    dayOfWeek
  }
}), _i18n.i18n.translate('xpack.triggersActionsUI.ruleSnoozeScheduler.recurSecond', {
  defaultMessage: 'Monthly on the second {dayOfWeek}',
  values: {
    dayOfWeek
  }
}), _i18n.i18n.translate('xpack.triggersActionsUI.ruleSnoozeScheduler.recurThird', {
  defaultMessage: 'Monthly on the third {dayOfWeek}',
  values: {
    dayOfWeek
  }
}), _i18n.i18n.translate('xpack.triggersActionsUI.ruleSnoozeScheduler.recurFourth', {
  defaultMessage: 'Monthly on the fourth {dayOfWeek}',
  values: {
    dayOfWeek
  }
})];
exports.i18nNthWeekday = i18nNthWeekday;
const i18nNthWeekdayShort = dayOfWeek => [_i18n.i18n.translate('xpack.triggersActionsUI.ruleSnoozeScheduler.recurLastShort', {
  defaultMessage: 'On the last {dayOfWeek}',
  values: {
    dayOfWeek
  }
}), _i18n.i18n.translate('xpack.triggersActionsUI.ruleSnoozeScheduler.recurFirstShort', {
  defaultMessage: 'On the 1st {dayOfWeek}',
  values: {
    dayOfWeek
  }
}), _i18n.i18n.translate('xpack.triggersActionsUI.ruleSnoozeScheduler.recurSecondShort', {
  defaultMessage: 'On the 2nd {dayOfWeek}',
  values: {
    dayOfWeek
  }
}), _i18n.i18n.translate('xpack.triggersActionsUI.ruleSnoozeScheduler.recurThirdShort', {
  defaultMessage: 'On the 3rd {dayOfWeek}',
  values: {
    dayOfWeek
  }
}), _i18n.i18n.translate('xpack.triggersActionsUI.ruleSnoozeScheduler.recurFourthShort', {
  defaultMessage: 'On the 4th {dayOfWeek}',
  values: {
    dayOfWeek
  }
})];
exports.i18nNthWeekdayShort = i18nNthWeekdayShort;
const i18nFreqSummary = interval => ({
  [_types.RRuleFrequency.DAILY]: _i18n.i18n.translate('xpack.triggersActionsUI.ruleSnoozeScheduler.recurDaySummary', {
    defaultMessage: '{interval, plural, one {day} other {# days}}',
    values: {
      interval
    }
  }),
  [_types.RRuleFrequency.WEEKLY]: _i18n.i18n.translate('xpack.triggersActionsUI.ruleSnoozeScheduler.recurWeekSummary', {
    defaultMessage: '{interval, plural, one {week} other {# weeks}}',
    values: {
      interval
    }
  }),
  [_types.RRuleFrequency.MONTHLY]: _i18n.i18n.translate('xpack.triggersActionsUI.ruleSnoozeScheduler.recurMonthSummary', {
    defaultMessage: '{interval, plural, one {month} other {# months}}',
    values: {
      interval
    }
  }),
  [_types.RRuleFrequency.YEARLY]: _i18n.i18n.translate('xpack.triggersActionsUI.ruleSnoozeScheduler.recurYearSummary', {
    defaultMessage: '{interval, plural, one {year} other {# years}}',
    values: {
      interval
    }
  })
});
exports.i18nFreqSummary = i18nFreqSummary;
const i18nEndControlOptions = interval => [{
  text: _i18n.i18n.translate('xpack.triggersActionsUI.ruleSnoozeScheduler.recurDay', {
    defaultMessage: '{interval, plural, one {day} other {days}}',
    values: {
      interval
    }
  }),
  value: _types.RRuleFrequency.DAILY,
  'data-test-subj': 'ruleSnoozeSchedulerRecurDay'
}, {
  text: _i18n.i18n.translate('xpack.triggersActionsUI.ruleSnoozeScheduler.recurWeek', {
    defaultMessage: '{interval, plural, one {week} other {weeks}}',
    values: {
      interval
    }
  }),
  value: _types.RRuleFrequency.WEEKLY,
  'data-test-subj': 'ruleSnoozeSchedulerRecurWeek'
}, {
  text: _i18n.i18n.translate('xpack.triggersActionsUI.ruleSnoozeScheduler.recurMonth', {
    defaultMessage: '{interval, plural, one {month} other {months}}',
    values: {
      interval
    }
  }),
  value: _types.RRuleFrequency.MONTHLY,
  'data-test-subj': 'ruleSnoozeSchedulerRecurMonth'
}, {
  text: _i18n.i18n.translate('xpack.triggersActionsUI.ruleSnoozeScheduler.recurYear', {
    defaultMessage: '{interval, plural, one {year} other {years}}',
    values: {
      interval
    }
  }),
  value: _types.RRuleFrequency.YEARLY,
  'data-test-subj': 'ruleSnoozeSchedulerRecurYear'
}];
exports.i18nEndControlOptions = i18nEndControlOptions;