"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ErrorBoundary = void 0;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _react = _interopRequireDefault(require("react"));
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

/**
 * A local error boundary component with a configurable fallback UI
 */
class ErrorBoundary extends _react.default.Component {
  constructor(...args) {
    super(...args);
    (0, _defineProperty2.default)(this, "state", {
      error: null
    });
  }
  static getDerivedStateFromError(error) {
    return {
      error
    };
  }
  render() {
    var _this$props$children;
    if (this.state.error != null) {
      const FallbackComponent = this.props.fallback;
      return /*#__PURE__*/_react.default.createElement(FallbackComponent, {
        error: this.state.error
      });
    }
    return (_this$props$children = this.props.children) !== null && _this$props$children !== void 0 ? _this$props$children : null;
  }
}
exports.ErrorBoundary = ErrorBoundary;