"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = exports.AddConnectorInline = void 0;
var _react = _interopRequireWildcard(require("react"));
var _i18n = require("@kbn/i18n");
var _i18nReact = require("@kbn/i18n-react");
var _eui = require("@elastic/eui");
var _translations = require("../translations");
var _capabilities = require("../../lib/capabilities");
var _kibana = require("../../../common/lib/kibana");
var _connectors = require("../common/connectors");
var _connectors_selection = require("./connectors_selection");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const AddConnectorInline = ({
  actionTypesIndex,
  actionItem,
  index,
  connectors,
  onAddConnector,
  onDeleteConnector,
  onSelectConnector,
  actionTypeRegistry,
  emptyActionsIds
}) => {
  var _actionTypeRegistered;
  const {
    application: {
      capabilities
    }
  } = (0, _kibana.useKibana)().services;
  const canSave = (0, _capabilities.hasSaveActionsCapability)(capabilities);
  const [hasConnectors, setHasConnectors] = (0, _react.useState)(false);
  const [isEmptyActionId, setIsEmptyActionId] = (0, _react.useState)(false);
  const actionTypeName = actionTypesIndex ? actionTypesIndex[actionItem.actionTypeId].name : actionItem.actionTypeId;
  const actionTypeRegistered = actionTypeRegistry.get(actionItem.actionTypeId);
  const allowGroupConnector = ((_actionTypeRegistered = actionTypeRegistered === null || actionTypeRegistered === void 0 ? void 0 : actionTypeRegistered.subtype) !== null && _actionTypeRegistered !== void 0 ? _actionTypeRegistered : []).map(subtype => subtype.id);
  const connectorDropdownErrors = (0, _react.useMemo)(() => [`Unable to load ${actionTypeRegistered.actionTypeTitle} connector`], [actionTypeRegistered.actionTypeTitle]);
  const noConnectorsLabel = /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.triggersActionsUI.sections.connectorAddInline.emptyConnectorsLabel",
    defaultMessage: "No {actionTypeName} connectors",
    values: {
      actionTypeName
    }
  });
  const unableToLoadConnectorLabel = /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    color: "danger"
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.triggersActionsUI.sections.connectorAddInline.unableToLoadConnectorTitle",
    defaultMessage: "Unable to load connector"
  }));
  (0, _react.useEffect)(() => {
    const filteredConnectors = (0, _connectors.getValidConnectors)(connectors, actionItem, actionTypesIndex, allowGroupConnector);
    if (filteredConnectors.length > 0) {
      setHasConnectors(true);
    }
    setIsEmptyActionId(!!emptyActionsIds.find(emptyId => actionItem.id === emptyId));
    // eslint-disable-next-line react-hooks/exhaustive-deps
  }, []);
  const connectorsDropdown = /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    fullWidth: true,
    label: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.triggersActionsUI.sections.connectorAddInline.connectorAddInline.actionIdLabel",
      defaultMessage: "Use another {connectorInstance} connector",
      values: {
        connectorInstance: actionTypeName
      }
    }),
    labelAppend: /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
      size: "xs",
      "data-test-subj": `addNewActionConnectorButton-${actionItem.actionTypeId}`,
      onClick: onAddConnector
    }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      defaultMessage: "Add connector",
      id: "xpack.triggersActionsUI.sections.connectorAddInline.connectorAddInline.addNewConnectorEmptyButton"
    })),
    error: connectorDropdownErrors,
    isInvalid: true
  }, /*#__PURE__*/_react.default.createElement(_connectors_selection.ConnectorsSelection, {
    actionItem: actionItem,
    accordionIndex: index,
    actionTypesIndex: actionTypesIndex,
    actionTypeRegistered: actionTypeRegistered,
    connectors: connectors,
    onConnectorSelected: onSelectConnector,
    allowGroupConnector: allowGroupConnector
  }));
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiAccordion, {
    key: index,
    initialIsOpen: true,
    id: index.toString(),
    className: "actAccordionActionForm",
    buttonContentClassName: "actAccordionActionForm__button",
    "data-test-subj": `alertActionAccordion-${index}`,
    buttonContent: /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
      gutterSize: "s",
      alignItems: "center"
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: false
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
      type: actionTypeRegistered.iconClass,
      size: "m"
    })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiText, null, /*#__PURE__*/_react.default.createElement("div", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      defaultMessage: "{actionConnectorName}",
      id: "xpack.triggersActionsUI.sections.connectorAddInline.newRuleActionTypeEditTitle",
      values: {
        actionConnectorName: actionTypeRegistered.actionTypeTitle
      }
    })))), !isEmptyActionId && /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: false
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiIconTip, {
      type: "warning",
      size: "m",
      color: "danger",
      "data-test-subj": `alertActionAccordionErrorTooltip`,
      content: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        defaultMessage: "Unable to load connector",
        id: "xpack.triggersActionsUI.sections.connectorAddInline.unableToLoadConnectorTitle'"
      })
    })), actionTypeRegistered && actionTypeRegistered.isExperimental && /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: false
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiBetaBadge, {
      label: _translations.TECH_PREVIEW_LABEL,
      tooltipContent: _translations.TECH_PREVIEW_DESCRIPTION
    }))),
    extraAction: /*#__PURE__*/_react.default.createElement(_eui.EuiButtonIcon, {
      iconType: "minusInCircle",
      color: "danger",
      className: "actAccordionActionForm__extraAction",
      "aria-label": _i18n.i18n.translate('xpack.triggersActionsUI.sections.connectorAddInline.accordion.deleteIconAriaLabel', {
        defaultMessage: 'Delete'
      }),
      onClick: onDeleteConnector
    }),
    paddingSize: "l"
  }, canSave ? hasConnectors ? connectorsDropdown : /*#__PURE__*/_react.default.createElement(_eui.EuiEmptyPrompt, {
    title: isEmptyActionId ? noConnectorsLabel : unableToLoadConnectorLabel,
    actions: /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
      color: "primary",
      fill: true,
      size: "s",
      "data-test-subj": `createActionConnectorButton-${index}`,
      onClick: onAddConnector
    }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.triggersActionsUI.sections.connectorAddInline.addConnectorButtonLabel",
      defaultMessage: "Create a connector"
    }))
  }) : /*#__PURE__*/_react.default.createElement(_eui.EuiCallOut, {
    title: noConnectorsLabel
  }, /*#__PURE__*/_react.default.createElement("p", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.triggersActionsUI.sections.connectorAddInline.unauthorizedToCreateForEmptyConnectors",
    defaultMessage: "Only authorized users can configure a connector. Contact your administrator."
  })))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "xs"
  }));
};

// eslint-disable-next-line import/no-default-export
exports.default = exports.AddConnectorInline = AddConnectorInline;