"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.loadGlobalConnectorExecutionKPIAggregations = void 0;
var _constants = require("../../constants");
var _get_filter = require("../rule_api/get_filter");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const loadGlobalConnectorExecutionKPIAggregations = ({
  http,
  outcomeFilter,
  message,
  dateStart,
  dateEnd,
  namespaces
}) => {
  const filter = (0, _get_filter.getFilter)({
    outcomeFilter,
    message
  });
  return http.post(`${_constants.INTERNAL_BASE_ACTION_API_PATH}/_global_connector_execution_kpi`, {
    body: JSON.stringify({
      filter: filter.length ? filter.join(' and ') : undefined,
      date_start: dateStart,
      date_end: dateEnd,
      namespaces: namespaces ? JSON.stringify(namespaces) : namespaces
    })
  });
};
exports.loadGlobalConnectorExecutionKPIAggregations = loadGlobalConnectorExecutionKPIAggregations;