"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.deleteActions = deleteActions;
var _constants = require("../../constants");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

async function deleteActions({
  ids,
  http
}) {
  const successes = [];
  const errors = [];
  await Promise.all(ids.map(id => http.delete(`${_constants.BASE_ACTION_API_PATH}/connector/${encodeURIComponent(id)}`))).then(function (fulfilled) {
    successes.push(...fulfilled);
  }, function (rejected) {
    errors.push(...rejected);
  });
  return {
    successes,
    errors
  };
}