"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useMultipleSpaces = void 0;
var _react = require("react");
var _kibana = require("../../common/lib/kibana");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const useMultipleSpaces = props => {
  const {
    setShowFromAllSpaces,
    showFromAllSpaces,
    visibleColumns,
    setVisibleColumns
  } = props;
  const spacesData = (0, _kibana.useSpacesData)();
  const onShowAllSpacesChange = (0, _react.useCallback)(() => {
    setShowFromAllSpaces(prev => !prev);
    const nextShowFromAllSpaces = !showFromAllSpaces;
    if (nextShowFromAllSpaces && !visibleColumns.includes('space_ids')) {
      const connectorNameIndex = visibleColumns.findIndex(c => c === 'connector_name');
      const newVisibleColumns = [...visibleColumns];
      newVisibleColumns.splice(connectorNameIndex + 1, 0, 'space_ids');
      setVisibleColumns(newVisibleColumns);
    } else if (!nextShowFromAllSpaces && visibleColumns.includes('space_ids')) {
      setVisibleColumns(visibleColumns.filter(c => c !== 'space_ids'));
    }
  }, [setShowFromAllSpaces, showFromAllSpaces, visibleColumns, setVisibleColumns]);
  const accessibleSpaceIds = (0, _react.useMemo)(() => spacesData ? [...spacesData.spacesMap.values()].map(e => e.id) : [], [spacesData]);
  const canAccessMultipleSpaces = (0, _react.useMemo)(() => accessibleSpaceIds.length > 1, [accessibleSpaceIds]);
  const namespaces = (0, _react.useMemo)(() => showFromAllSpaces && spacesData ? accessibleSpaceIds : undefined, [showFromAllSpaces, spacesData, accessibleSpaceIds]);
  const activeSpace = (0, _react.useMemo)(() => spacesData === null || spacesData === void 0 ? void 0 : spacesData.spacesMap.get(spacesData === null || spacesData === void 0 ? void 0 : spacesData.activeSpaceId), [spacesData]);
  return {
    onShowAllSpacesChange,
    canAccessMultipleSpaces,
    namespaces,
    activeSpace
  };
};
exports.useMultipleSpaces = useMultipleSpaces;