"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useExecuteConnector = void 0;
var _react = require("react");
var _action_connector_api = require("../lib/action_connector_api");
var _kibana = require("../../common/lib/kibana");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const useExecuteConnector = () => {
  const {
    http
  } = (0, _kibana.useKibana)().services;
  const [isLoading, setIsLoading] = (0, _react.useState)(false);
  const abortCtrlRef = (0, _react.useRef)(new AbortController());
  const isMounted = (0, _react.useRef)(false);
  async function executeConnector({
    connectorId,
    params
  }) {
    setIsLoading(true);
    isMounted.current = true;
    abortCtrlRef.current.abort();
    abortCtrlRef.current = new AbortController();
    try {
      const res = await (0, _action_connector_api.executeAction)({
        http,
        id: connectorId,
        params
      });
      if (isMounted.current) {
        setIsLoading(false);
      }
      return res;
    } catch (error) {
      if (isMounted.current) {
        setIsLoading(false);
        if (error.name !== 'AbortError') {
          throw error;
        }
      }
    }
  }
  (0, _react.useEffect)(() => {
    isMounted.current = true;
    return () => {
      isMounted.current = false;
      abortCtrlRef.current.abort();
    };
  }, []);
  return {
    isLoading,
    executeConnector
  };
};
exports.useExecuteConnector = useExecuteConnector;