"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.FormTestProvider = void 0;
var _react = _interopRequireWildcard(require("react"));
var _i18nReact = require("@kbn/i18n-react");
var _eui = require("@elastic/eui");
var _hook_form_lib = require("@kbn/es-ui-shared-plugin/static/forms/hook_form_lib");
var _connector_context = require("../context/connector_context");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const FormTestProviderComponent = ({
  children,
  defaultValue,
  onSubmit,
  connectorServices = {
    validateEmailAddresses: jest.fn(),
    enabledEmailServices: ['*']
  }
}) => {
  const {
    form
  } = (0, _hook_form_lib.useForm)({
    defaultValue
  });
  const {
    submit
  } = form;
  const onClick = (0, _react.useCallback)(async () => {
    const res = await submit();
    if (onSubmit) {
      onSubmit(res);
    }
  }, [onSubmit, submit]);
  return /*#__PURE__*/_react.default.createElement(_i18nReact.I18nProvider, null, /*#__PURE__*/_react.default.createElement(_connector_context.ConnectorProvider, {
    value: {
      services: connectorServices
    }
  }, /*#__PURE__*/_react.default.createElement(_hook_form_lib.Form, {
    form: form
  }, children), /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
    "data-test-subj": "form-test-provide-submit",
    onClick: onClick
  })));
};
FormTestProviderComponent.displayName = 'FormTestProvider';
const FormTestProvider = exports.FormTestProvider = /*#__PURE__*/_react.default.memo(FormTestProviderComponent);