"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.License = void 0;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _mlRouteUtils = require("@kbn/ml-route-utils");
var _constants = require("../../common/constants");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

class License {
  constructor({
    pluginId,
    minimumLicenseType,
    defaultErrorMessage,
    licensing,
    logger,
    coreStart
  }) {
    (0, _defineProperty2.default)(this, "coreStart", void 0);
    (0, _defineProperty2.default)(this, "licenseStatus", {
      isValid: false,
      isSecurityEnabled: false,
      message: 'Invalid License'
    });
    this.coreStart = coreStart;
    licensing.license$.subscribe(license => {
      const {
        state,
        message
      } = license.check(pluginId, minimumLicenseType);
      const hasRequiredLicense = state === 'valid';
      const securityFeature = license.getFeature('security');
      const isSecurityEnabled = securityFeature !== undefined && securityFeature.isAvailable === true && securityFeature.isEnabled === true;
      if (hasRequiredLicense) {
        this.licenseStatus = {
          isValid: true,
          isSecurityEnabled
        };
      } else {
        this.licenseStatus = {
          isValid: false,
          isSecurityEnabled,
          message: message || defaultErrorMessage
        };
        if (message) {
          logger.info(message);
        }
      }
    });
  }
  guardApiRoute(handler) {
    const license = this;
    return async function licenseCheck(ctx, request, response) {
      const licenseStatus = license.getStatus();
      const executionContext = (0, _mlRouteUtils.createExecutionContext)(license.coreStart, _constants.PLUGIN.ID, request.route.path);
      if (!licenseStatus.isValid) {
        return response.customError({
          body: {
            message: licenseStatus.message || ''
          },
          statusCode: 403
        });
      }
      return await license.coreStart.executionContext.withContext(executionContext, () => handler(ctx, request, response));
    };
  }
  getStatus() {
    return this.licenseStatus;
  }
}
exports.License = License;