"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useStopAction = void 0;
var _react = _interopRequireWildcard(require("react"));
var _transform_list = require("../../../../common/transform_list");
var _constants = require("../../../../../../common/constants");
var _hooks = require("../../../../hooks");
var _stop_action_name = require("./stop_action_name");
var _managed_transforms_utils = require("../../../../common/managed_transforms_utils");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const useStopAction = forceDisable => {
  const {
    canStartStopTransform
  } = (0, _hooks.useTransformCapabilities)();
  const stopTransforms = (0, _hooks.useStopTransforms)();
  const [isModalVisible, setModalVisible] = (0, _react.useState)(false);
  const [items, setItems] = (0, _react.useState)([]);
  const closeModal = () => setModalVisible(false);
  const openModal = newItems => {
    if (Array.isArray(newItems)) {
      setItems(newItems);
      setModalVisible(true);
    }
  };
  const stopAndCloseModal = (0, _react.useCallback)(transformSelection => {
    setModalVisible(false);
    stopTransforms(transformSelection.map(t => ({
      id: t.id,
      state: t.stats ? t.stats.state : 'waiting'
    })));
  }, [stopTransforms]);
  const clickHandler = (0, _react.useCallback)(t => stopTransforms([{
    id: t.id,
    state: t.stats ? t.stats.state : 'waiting'
  }]), [stopTransforms]);
  const action = (0, _react.useMemo)(() => ({
    name: item => /*#__PURE__*/_react.default.createElement(_stop_action_name.StopActionName, {
      items: [item],
      forceDisable: forceDisable
    }),
    available: item => (0, _transform_list.isTransformListRowWithStats)(item) ? item.stats.state !== _constants.TRANSFORM_STATE.STOPPED : true,
    enabled: item => (0, _transform_list.isTransformListRowWithStats)(item) && !(0, _stop_action_name.isStopActionDisabled)([item], canStartStopTransform, forceDisable),
    description: _stop_action_name.stopActionNameText,
    icon: 'stop',
    type: 'icon',
    onClick: item => {
      if ((0, _managed_transforms_utils.isManagedTransform)(item)) {
        openModal([item]);
      } else {
        clickHandler(item);
      }
    },
    'data-test-subj': 'transformActionStop'
  }), [canStartStopTransform, clickHandler, forceDisable]);
  return {
    action,
    closeModal,
    openModal,
    isModalVisible,
    items,
    stopAndCloseModal
  };
};
exports.useStopAction = useStopAction;