"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.StopActionModal = void 0;
var _react = _interopRequireWildcard(require("react"));
var _i18n = require("@kbn/i18n");
var _eui = require("@elastic/eui");
var _managed_transforms_utils = require("../../../../common/managed_transforms_utils");
var _managed_transforms_callout = require("../managed_transforms_callout/managed_transforms_callout");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const StopActionModal = ({
  closeModal,
  items,
  stopAndCloseModal
}) => {
  const hasManagedTransforms = (0, _react.useMemo)(() => items.some(t => (0, _managed_transforms_utils.isManagedTransform)(t)), [items]);
  const isBulkAction = items.length > 1;
  const bulkStopModalTitle = _i18n.i18n.translate('xpack.transform.transformList.bulkStopModalTitle', {
    defaultMessage: 'Stop {count} {count, plural, one {transform} other {transforms}}?',
    values: {
      count: items && items.length
    }
  });
  const stopModalTitle = _i18n.i18n.translate('xpack.transform.transformList.stopModalTitle', {
    defaultMessage: 'Stop {transformId}?',
    values: {
      transformId: items[0] && items[0].config.id
    }
  });
  return /*#__PURE__*/_react.default.createElement(_eui.EuiConfirmModal, {
    "data-test-subj": "transformStopModal",
    title: isBulkAction === true ? bulkStopModalTitle : stopModalTitle,
    onCancel: closeModal,
    onConfirm: () => stopAndCloseModal(items),
    cancelButtonText: _i18n.i18n.translate('xpack.transform.transformList.startModalCancelButton', {
      defaultMessage: 'Cancel'
    }),
    confirmButtonText: _i18n.i18n.translate('xpack.transform.transformList.startModalStopButton', {
      defaultMessage: 'Stop'
    }),
    defaultFocusedButton: _eui.EUI_MODAL_CONFIRM_BUTTON,
    buttonColor: "primary"
  }, hasManagedTransforms ? /*#__PURE__*/_react.default.createElement(_managed_transforms_callout.ManagedTransformsWarningCallout, {
    count: items.length,
    action: _i18n.i18n.translate('xpack.transform.transformList.stopManagedTransformsDescription', {
      defaultMessage: 'stopping'
    })
  }) : null);
};
exports.StopActionModal = StopActionModal;