"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.WizardNav = void 0;
var _react = _interopRequireDefault(require("react"));
var _i18n = require("@kbn/i18n");
var _eui = require("@elastic/eui");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const WizardNav = ({
  previous,
  previousActive = true,
  next,
  nextActive = true
}) => /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null), previous && /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
  grow: false
}, /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
  disabled: !previousActive,
  onClick: previous,
  iconType: "arrowLeft",
  size: "s",
  "data-test-subj": "transformWizardNavButtonPrevious"
}, _i18n.i18n.translate('xpack.transform.wizard.previousStepButton', {
  defaultMessage: 'Previous'
}))), next && /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
  grow: false
}, /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
  disabled: !nextActive,
  onClick: next,
  iconType: "arrowRight",
  size: "s",
  "data-test-subj": "transformWizardNavButtonNext"
}, _i18n.i18n.translate('xpack.transform.wizard.nextStepButton', {
  defaultMessage: 'Next'
}))));
exports.WizardNav = WizardNav;