"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.PivotFunctionForm = void 0;
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _use_documentation_links = require("../../../../hooks/use_documentation_links");
var _advanced_pivot_editor = require("../advanced_pivot_editor");
var _advanced_pivot_editor_switch = require("../advanced_pivot_editor_switch");
var _pivot_configuration = require("../pivot_configuration");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const advancedEditorsSidebarWidth = '220px';
const PivotFunctionForm = ({
  applyPivotChangesHandler,
  copyToClipboardPivot,
  copyToClipboardPivotDescription,
  stepDefineForm
}) => {
  const {
    esTransformPivot
  } = (0, _use_documentation_links.useDocumentationLinks)();
  const {
    isAdvancedPivotEditorEnabled,
    isAdvancedPivotEditorApplyButtonEnabled
  } = stepDefineForm.advancedPivotEditor.state;
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    justifyContent: "spaceBetween"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, !isAdvancedPivotEditorEnabled && /*#__PURE__*/_react.default.createElement(_pivot_configuration.PivotConfiguration, stepDefineForm.pivotConfig), isAdvancedPivotEditorEnabled && /*#__PURE__*/_react.default.createElement(_advanced_pivot_editor.AdvancedPivotEditor, stepDefineForm.advancedPivotEditor)), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    style: {
      width: advancedEditorsSidebarWidth
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    gutterSize: "xs",
    direction: "column",
    justifyContent: "spaceBetween"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    hasEmptyLabelSpace: true
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    alignItems: "center",
    justifyContent: "spaceBetween"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_advanced_pivot_editor_switch.AdvancedPivotEditorSwitch, stepDefineForm)), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiCopy, {
    beforeMessage: copyToClipboardPivotDescription,
    textToCopy: copyToClipboardPivot
  }, copy => /*#__PURE__*/_react.default.createElement(_eui.EuiButtonIcon, {
    onClick: copy,
    iconType: "copyClipboard",
    "aria-label": copyToClipboardPivotDescription
  })))))), isAdvancedPivotEditorEnabled && /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    style: {
      width: advancedEditorsSidebarWidth
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "s"
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    size: "xs"
  }, /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, _i18n.i18n.translate('xpack.transform.stepDefineForm.advancedEditorHelpText', {
    defaultMessage: 'The advanced editor allows you to edit the pivot configuration of the transform.'
  }), ' ', /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
    href: esTransformPivot,
    target: "_blank"
  }, _i18n.i18n.translate('xpack.transform.stepDefineForm.advancedEditorHelpTextLink', {
    defaultMessage: 'Learn more about available options.'
  })))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "s"
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
    style: {
      width: 'fit-content'
    },
    size: "s",
    fill: true,
    onClick: applyPivotChangesHandler,
    disabled: !isAdvancedPivotEditorApplyButtonEnabled
  }, _i18n.i18n.translate('xpack.transform.stepDefineForm.advancedEditorApplyButtonText', {
    defaultMessage: 'Apply changes'
  }))))));
};
exports.PivotFunctionForm = PivotFunctionForm;