"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.PercentilesAggForm = void 0;
var _react = _interopRequireWildcard(require("react"));
var _i18n = require("@kbn/i18n");
var _eui = require("@elastic/eui");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const PercentilesAggForm = ({
  aggConfig,
  onChange,
  isValid,
  errorMessages
}) => {
  const selectedOptions = (0, _react.useMemo)(() => {
    var _aggConfig$percents$m, _aggConfig$percents;
    return (_aggConfig$percents$m = (_aggConfig$percents = aggConfig.percents) === null || _aggConfig$percents === void 0 ? void 0 : _aggConfig$percents.map(p => ({
      label: p.toString()
    }))) !== null && _aggConfig$percents$m !== void 0 ? _aggConfig$percents$m : [];
  }, [aggConfig.percents]);
  const handleCreateOption = (0, _react.useCallback)(inputValue => {
    if (!isValid) return false;
    const newValue = Number(inputValue.replace(',', '.'));
    const newOption = {
      label: newValue.toString()
    };
    const updatedOptions = [...selectedOptions, newOption];
    onChange({
      percents: updatedOptions.map(option => Number(option.label))
    });
  }, [isValid, onChange, selectedOptions]);
  const handleOptionsChange = (0, _react.useCallback)(newOptions => {
    onChange({
      percents: newOptions.map(option => Number(option.label))
    });
  }, [onChange]);
  const handleSearchChange = (0, _react.useCallback)(searchValue => {
    // If we're clearing the input after a valid creation,
    // this is the post-creation cleanup
    if (searchValue === '' && aggConfig.pendingPercentileInput && isValid) return;
    onChange({
      ...aggConfig,
      pendingPercentileInput: searchValue
    });
  }, [aggConfig, onChange, isValid]);

  // Get the last error message if there are any
  const lastErrorMessage = errorMessages !== null && errorMessages !== void 0 && errorMessages.length ? errorMessages[errorMessages.length - 1] : undefined;
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    label: _i18n.i18n.translate('xpack.transform.agg.popoverForm.percentsLabel', {
      defaultMessage: 'Percents'
    }),
    error: lastErrorMessage,
    isInvalid: !isValid
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiComboBox, {
    noSuggestions: true,
    selectedOptions: selectedOptions,
    onCreateOption: handleCreateOption,
    onChange: handleOptionsChange,
    onSearchChange: handleSearchChange,
    isInvalid: !isValid,
    "data-test-subj": "transformPercentilesAggPercentsSelector"
  })));
};
exports.PercentilesAggForm = PercentilesAggForm;