"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useTransformCapabilities = void 0;
var _capabilities = require("../../../common/types/capabilities");
var _app_dependencies = require("../app_dependencies");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const useTransformCapabilities = () => {
  var _application$capabili;
  const {
    application
  } = (0, _app_dependencies.useAppDependencies)();
  if ((0, _capabilities.isTransformCapabilities)(application === null || application === void 0 ? void 0 : (_application$capabili = application.capabilities) === null || _application$capabili === void 0 ? void 0 : _application$capabili.transform)) {
    return application.capabilities.transform;
  }
  return (0, _capabilities.getInitialTransformCapabilities)();
};
exports.useTransformCapabilities = useTransformCapabilities;