"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useGetTransformsPreview = void 0;
var _reactQuery = require("@tanstack/react-query");
var _constants = require("../../../common/constants");
var _app_dependencies = require("../app_dependencies");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const useGetTransformsPreview = (obj, enabled) => {
  const {
    http
  } = (0, _app_dependencies.useAppDependencies)();
  return (0, _reactQuery.useQuery)([_constants.TRANSFORM_REACT_QUERY_KEYS.GET_TRANSFORMS_PREVIEW, obj], ({
    signal
  }) => http.post((0, _constants.addInternalBasePath)('transforms/_preview'), {
    body: JSON.stringify(obj),
    version: '1',
    signal
  }), {
    enabled
  });
};
exports.useGetTransformsPreview = useGetTransformsPreview;