"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getDateISORange = getDateISORange;
exports.getDateRange = getDateRange;
exports.getOffsetFromNowInSeconds = getOffsetFromNowInSeconds;
exports.getTimeDifferenceInSeconds = getTimeDifferenceInSeconds;
var _datemath = _interopRequireDefault(require("@kbn/datemath"));
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

function getParsedDate(rawDate, options = {}) {
  if (rawDate) {
    const parsed = _datemath.default.parse(rawDate, options);
    if (parsed && parsed.isValid()) {
      return parsed.toDate();
    }
  }
}
function getRanges({
  from,
  to
}) {
  const start = getParsedDate(from);
  const end = getParsedDate(to, {
    roundUp: true
  });
  if (!start || !end || start > end) {
    throw new Error(`Invalid Dates: from: ${from}, to: ${to}`);
  }
  const startDate = start.toISOString();
  const endDate = end.toISOString();
  return {
    startDate,
    endDate
  };
}
function getDateRange({
  from,
  to
}) {
  const {
    startDate,
    endDate
  } = getRanges({
    from,
    to
  });
  return {
    startDate: new Date(startDate).getTime(),
    endDate: new Date(endDate).getTime()
  };
}
function getDateISORange({
  from,
  to
}) {
  const {
    startDate,
    endDate
  } = getRanges({
    from,
    to
  });
  return {
    startDate,
    endDate
  };
}
function getTimeDifferenceInSeconds({
  startDate,
  endDate
}) {
  if (!startDate || !endDate || startDate > endDate) {
    throw new Error(`Invalid Dates: from: ${startDate}, to: ${endDate}`);
  }
  const rangeInSeconds = (endDate - startDate) / 1000;
  return Math.round(rangeInSeconds);
}
function getOffsetFromNowInSeconds(epochDate) {
  const now = Date.now();
  return Math.round((epochDate - now) / 1000);
}