"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.twoGroups = exports.providerF = exports.providerE = exports.providerD = exports.providerC = exports.providerB = exports.providerA = void 0;
var _timeline = require("../../common/types/timeline");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const providerA = exports.providerA = {
  enabled: true,
  excluded: false,
  id: 'context-field.name-a',
  kqlQuery: '',
  name: 'a',
  queryMatch: {
    field: 'field.name',
    value: 'a',
    operator: _timeline.IS_OPERATOR
  }
};
const providerB = exports.providerB = {
  enabled: true,
  excluded: false,
  id: 'context-field.name-b',
  kqlQuery: '',
  name: 'b',
  queryMatch: {
    field: 'field.name',
    value: 'b',
    operator: _timeline.IS_OPERATOR
  }
};
const providerC = exports.providerC = {
  enabled: true,
  excluded: false,
  id: 'context-field.name-c',
  kqlQuery: '',
  name: 'c',
  queryMatch: {
    field: 'field.name',
    value: 'c',
    operator: _timeline.IS_OPERATOR
  }
};
const providerD = exports.providerD = {
  enabled: true,
  excluded: false,
  id: 'context-field.name-d',
  kqlQuery: '',
  name: 'd',
  queryMatch: {
    field: 'field.name',
    value: 'd',
    operator: _timeline.IS_OPERATOR
  }
};
const providerE = exports.providerE = {
  enabled: true,
  excluded: false,
  id: 'context-field.name-e',
  kqlQuery: '',
  name: 'e',
  queryMatch: {
    field: 'field.name',
    value: 'e',
    operator: _timeline.IS_OPERATOR
  }
};
const providerF = exports.providerF = {
  enabled: true,
  excluded: false,
  id: 'context-field.name-f',
  kqlQuery: '',
  name: 'f',
  queryMatch: {
    field: 'field.name',
    value: 'f',
    operator: _timeline.IS_OPERATOR
  }
};
const twoGroups = exports.twoGroups = [{
  ...providerA,
  and: [providerB, providerC]
}, {
  ...providerD,
  and: [providerE, providerF]
}];