"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.toStringArray = exports.toObjectArrayOfStrings = exports.toArray = void 0;
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const toArray = value => value == null ? [] : Array.isArray(value) ? value : [value];
exports.toArray = toArray;
const toStringArray = value => {
  if (value == null) return [];
  const arr = Array.isArray(value) ? value : [value];
  return arr.reduce((acc, v) => {
    if (v == null) return acc;
    if (typeof v === 'object') {
      try {
        acc.push(JSON.stringify(v));
      } catch {
        acc.push('Invalid Object');
      }
      return acc;
    }
    acc.push(String(v));
    return acc;
  }, []);
};
exports.toStringArray = toStringArray;
const toObjectArrayOfStrings = value => {
  if (value == null) return [];
  const arr = Array.isArray(value) ? value : [value];
  return arr.reduce((acc, v) => {
    if (v == null) return acc;
    if (typeof v === 'object') {
      try {
        acc.push({
          str: JSON.stringify(v),
          isObjectArray: true
        });
      } catch {
        acc.push({
          str: 'Invalid Object'
        });
      }
      return acc;
    }
    acc.push({
      str: String(v)
    });
    return acc;
  }, []);
};
exports.toObjectArrayOfStrings = toObjectArrayOfStrings;